////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: DarkRoom 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DARK_ROOM_H_
#define _DARK_ROOM_H_

#include <darkroomable.h>
#include <surface.h>

#pragma C+

/*
 *  DarkRoom: DarkRoomable, Surface
 *
 *  A dark Room.  The player must have some object that can act as a
 *  light source in order to move about and perform most operations
 *  while in this room.  Note that the room's lights can be turned
 *  on by setting the room's lightsOn property to true;
 *  do this instead of setting isLit(), because isLit() is
 *  a method which checks for the presence of light.
 */
class DarkRoom: DarkRoomable, Surface       // An enterable area which might be dark
    boardingPrep = "in"
    unboardingPrep = "out of"
;

#pragma C-

#endif /* _DARK_ROOM_H_ */
