////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: String 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _STRING_H_
#define _STRING_H_

#include <story.t>

#pragma C+

/*
 *  String: object
 *
 *  This object provides a default implementation for strObj.
 *  To use this default unchanged in your game, include in your
 *  game this line:  "strObj: String".
 */
class String: object   // when a string is used in a player command,
    value = ''              //  this is set to its value
    sDesc = "\"<<value>>\""
    aDesc = "\"<<value>>\""
    theDesc = "\"<<value>>\""
    verDoRestore(actor) = {}
    doRestore(actor) = {
        self.restoreGame(actor);
        abort;
    }
    restoreGame(actor) = {
        return story.mainRestore(self.value);
    }
    verDoSave(actor) = {}
    doSave(actor) = {
        self.saveGame(actor);
        abort;
    }
    saveGame(actor) = {
        if (save(self.value)) {
            "Save failed. ";
            return nil;
        } else {
            "Saved. ";
            return true;
        }
    }
    verDoSay(actor) = {}
    doSay(actor) = {
        "Okay, \""; say(self.value); "\".";
    }
    verDoScript(actor) = {}
    doScript(actor) = {
        self.startScripting(actor);
        abort;
    }
    startScripting(actor) = {
        logging(self.value);
        "Writing script file. ";
    }
    verDoTypeOn(actor, io) = {}
    doTypeOn(actor, io) = { "\"Tap, tap, tap, tap...\" "; }
    doSynonym('TypeOn') = 'EnterOn' 'EnterIn' 'EnterWith'
;

/*
 *   strObj works like numObj, but for strings.  So, a player command of
 *     type "hello" on the keyboard
 *   will result in a direct object of strObj, with its "value" property
 *   set to the string 'hello'.
 *
 *   Note that, because a string direct object is used in the save, restore,
 *   and script commands, this object must handle those commands.
 */
strObj: String
;

#pragma C-

#endif /* _STRING_H_ */
