////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: moveFloating() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _MOVE_FLOATING_T_
#define _MOVE_FLOATING_T_

#include <global.t>

#pragma C+

/*
 *  This function moves each Floating object to its location. This is
 *  done during preinit(), DeepVerb.validXoList(), and preCommand(). 
 */
moveFloating: function(actor) {
    local i, o, len = length(global.floatingList);
    
    for (i = 1; i <= len; i++)
	    global.floatingList[i].setLocation(actor);
}

#pragma C-

#endif /* _MOVE_FLOATING_T_ */
