// Skeleton gamefile.  Only three things need be in a game compiled with ts_std:  commence,
//  version, and startroom.  version generally goes in the front, like so:

version: object
    sdesc = "Skeleton Game"
    ldesc = "Skeleton Game v0.0 by TenthStone.  A bare game template for the
        Pianosa libraries. "
;

#include <ts_std.t>
#include <ts_grid.t>
commence : function;

// commence is called by init after initCommon;  initCommon calls initLibrary
//  and sets the sleep and hunger daemons.  initLibrary sets turncount and
//  and the Reactor daemon.
// In this case, all we have to do is write a poem.
commence: function {
    "\b bone lies silent in the dew,
    \n  horrid mass forgotten by the dawn,
    \n  night's imagery complete. ";
}

startroom: caverns
    sdesc = "Skeleton's Isle"
    ldesc = "This deserted island, often featured in Far Side cartoons, is
        dull without the wit of Gary Larson.  There's an entrance to a
        cave to the east. "
    east = [ dynamicgrid caverns ]
    cavernsX = -1
    cavernsY = 0
    cavernsZ = 0
;

endroom: caverns
    sdesc = "A Hawaiian Beach"
    ldesc = "This popular maven for the rich and well-tanned is bustling
        with human life.  There's an entrance to a cave to the south. "
    cavernsX = 2
    cavernsY = 3
    cavernsZ = 0
;

class caverns: dynamicgridclass
    xposProp = &cavernsX
    yposProp = &cavernsY
    zposProp = &cavernsZ
    approve( x, y, z, loc, dir ) = {
        if (z = 0) {
         if (x >= 0) {
          if (x <= 2) {
           if (y >= 0) {
            if (y <= 2) {
              if (x = 1 and y = 1) {
                self.cantexit; return nil;
              }
              return true;
            }
           }
          }
         }
        }
        self.cantexit; return nil;
    }
    initiate = {
        if (self.cavernsY < 2 and self.cavernsX <> 1) self.north := [ dynamicgrid caverns ];
        if (self.cavernsX < 2 and self.cavernsY <> 1) self.east := [ dynamicgrid caverns ];
        if (self.cavernsY > 0 and self.cavernsX <> 1) self.south := [ dynamicgrid caverns ];
        if (self.cavernsX > 0 and self.cavernsY <> 1) self.west := [ dynamicgrid caverns ];
    }
    sdesc = "Caverns"
    ldesc = {
        "Exits: ";
        if (self.north) " north";
        if (self.south) " south";
        if (self.east) " east";
        if (self.west) " west";
        "\n\t";
    }
;

cavernjunction: lowercaverns, caverns
    cavernsX = 3
    cavernsY = 0
    cavernsZ = 0
    lcX = 5
    lcY = 5
    lcZ = 1
    down = [ dynamicgrid lowercaverns ]
    dynamicLinkTo( obj, dir, dx, dy, dz, cls ) = {
        switch (dx) {
          case -1: case 1:
            switch (dy) {
              case -1: case 1: return nil;
            }
        }
        self.dir := obj;
        return true;
    }
;

largecavern: lowercaverns
    lcX = 4
    lcY = 3
    lcZ = 0
    north = [ dynamicgrid lowercaverns ]
    east = [ dynamicgrid lowercaverns ]
    sdesc = "Large Cavern"
    ldesc = { "The passage opens up here for a bit.\n"; pass ldesc; }
    enterRoom( a ) = {
      if (not self.isseen) {
        if (_rand( 5 ) > 3 and lowercaverns.dynamicLookup( lcX, lcY - 1, lcZ ) = nil) self.south := [ dynamicgrid lowercaverns ];
        if (_rand( 5 ) > 3 and lowercaverns.dynamicLookup( lcX - 1, lcY, lcZ ) = nil) self.west := [ dynamicgrid lowercaverns ];
      }
      pass enterRoom;
    }
;

narrowcavern: lowercaverns
    lcX = 7
    lcY = 8
    lcZ = 0
    south = [ dynamicgrid lowercaverns ]
    east = [ dynamicgrid lowercaverns ]
    sdesc = "Narrow Cavern"
    ldesc = { "The passage narrows slightly here.\n"; pass ldesc; }
;

class mazebar: item
    noun = 'bar'
    sdesc = "<< getwords( self, &adjective )[1] >> bar"
    ldesc = "A standard maze-mapping bar, made by Frobozz Adventurer's
        Aid Company. This one is << getwords( self, &adjective )[1] >>. "
;

greybar: mazebar adjective = 'grey' 'gray';
blackbar: mazebar adjective = 'black';
whitebar: mazebar adjective = 'white';

modify room
    dynamicLinkTo( obj, dir, dx, dy, dz, cls ) = {
        switch (dx) {
          case -1: case 1:
            switch (dy) {
              case -1: case 1: return nil;
            }
        }
        self.dir := obj;
        return true;
    }
;

// infinite caverns (maybe)
class lowercaverns: dynamicgridclass
    xposProp = &lcX
    yposProp = &lcY
    zposProp = &lcZ
    approve( x, y, z, loc, dir ) = {
        if (z = 0) return true;
        self.cantexit; return nil;
    }
    initiate = {
        if (_rand( 5 ) > 3 and lowercaverns.dynamicLookup( lcX, lcY + 1, lcZ ) = nil) self.north := [ dynamicgrid lowercaverns ];
        if (_rand( 5 ) > 3 and lowercaverns.dynamicLookup( lcX + 1, lcY, lcZ ) = nil) self.east := [ dynamicgrid lowercaverns ];
        if (_rand( 5 ) > 3 and lowercaverns.dynamicLookup( lcX, lcY - 1, lcZ ) = nil) self.south := [ dynamicgrid lowercaverns ];
        if (_rand( 5 ) > 3 and lowercaverns.dynamicLookup( lcX - 1, lcY, lcZ ) = nil) self.west := [ dynamicgrid lowercaverns ];
        if (_rand( 10 ) > 8) {
          local o;
          for (o := firstobj( mazebar ); o; o := nextobj( o, mazebar ))
            if (o.locate = nil) { o.putInto( self, On ); break; }
        }
    }
    sdesc = "Caverns"
    ldesc = {
        "Exits: ";
        if (self.north) " north";
        if (self.south) " south";
        if (self.east) " east";
        if (self.west) " west";
        if (self.down) " down";
        if (self.up) " up";
        "\n\t";
    }
    dynamicLinkTo( obj, dir, dx, dy, dz, cls ) = {
        if (obj.(cls.translateProp( -dx, -dy, -dz )) = nil) return nil;
        switch (dx) {
          case -1: case 1:
            switch (dy) {
              case -1: case 1: return nil;
            }
        }
        self.dir := obj;
        return true;
    }
;

Jime: Actress, basicMe
    noun = 'jime'
    on = startroom
    actorname = "Jime"
    bdesc = "Jime stands here, staring blankly at you. "
    ldesc = "Her name is Jime."
    actorAction( v, d, p, i ) = {
        if (v <> followVerb) pass actorAction;
    }
;

changeVerb: sysVerb
    verb = 'change'
    verbtask( a ) = {
        if (parserGetMe() = Me) parserSetMe( Jime );
        else parserSetMe( Me );
        parserGetMe().locate.lookAround( true );
    }
;

modify Me
    actorname = 'player'
;
