#include <ts_codes.t>
#include <ts_menu.t>

//  Stolen from ADV.T
inputLine: function {
    local ret, HTML_mode := (systemInfo(__SYSINFO_SYSINFO) = true and systemInfo(__SYSINFO_HTML_MODE));
    if (HTML_mode) "<font face='TADS-Input'>";
    ret := input();
    if (HTML_mode) "</font>";
    return ret;
}

gac: function( cls, ... ) {
    local lst := [], o, prop, val := true, parm;
    switch (argcount) {
        case 4: parm := getarg( 4 );
        case 3: val := getarg( 3 );
        case 2: prop := getarg( 2 );
    }
    for (o := firstobj( cls ); o; o := nextobj( o, cls )) {
        if (prop) {
          if (argcount >= 4) {
            if (o.(prop)( parm ) = val) lst += o;
          }
          else if (o.(prop) = val) lst += o;
        }
        else lst += o;
    }
    return lst;
}

pardon: function {}

init: function {
    writeMenu( mainMenu );
}

class mainMenu: menuclass
    menuTitle = "TADS-Pianosa Position Generator"
    orderMenu( lst, l, p ) = {
        return lst;
    }
;

takeVerb: mainMenu
    menuDesc = "\(N\)ew Position"
    menuKeys = [ 'n' 'new' 'position' 'p' ]
    menuAction( c, l, p ) = {
        local postemp, outfile;
        "\bOpening << Me.file >> ...\ ";
        postemp := fopen( Me.file, 'rt' );
        if (postemp = nil) {
          "failed!\b";
          return;
        }
        "okay.
        \bOutput file: ";
        outfile := inputLine();
        " ...\ ";
        if (outfile = '') "aborted!\b";
        else {
          Me.ouputfile := outfile;
          outfile := fopen( outfile, 'wt' );
          if (outfile = nil) "failed!\b";
          else {
            "okay. \b";
            parseFile( postemp, outfile );
            fclose( outfile );
          }
        }
        fclose( postemp );
    }
;

againVerb: mainMenu
    menuDesc = "\(C\)hange mergefile (<< Me.file >>)"
    menuKeys = [ 'c' 'change' 'm' 'mergefile' ]
    menuAction( c, l, p ) = {
      local mfile;
      mfile := askfile( 'Select Mergefile', ASKFILE_PROMPT_OPEN, FILE_TYPE_UNKNOWN, ASKFILE_EXT_RESULT );
      switch (mfile[1]) {
        case ASKFILE_CANCEL: "Aborted. "; return;
        case ASKFILE_SUCCESS: mfile := mfile[2]; break;
        case ASKFILE_FAILURE:
          "\bMergefile: ";
          mfile := inputLine();
          if (mfile = '') {
            "Aborted. ";
            return;
          }
      }
      Me.file := mfile;
    }
;

numObj: mainMenu
    menuDesc = "\(A\)bout"
    menuKeys = [ 'a' 'about' ]
    menuAction( c, l, p ) = {
      "\bThe Frobozz Magic TADS-Pianosa Position Generator.
      \nVersion 1.0.  A utility for the Pianosa library.
      \bWritten by TenthStone (tenthstone@hotmail.com), originally
      in QuickBasic until Neil K.\ Guy informed me that TADS now had ASCII
      capabilities, in which case I jumped at the case to make a portable
      version.  First released in the Pianosa 0.6 distribution. ";
      morePrompt();
    }
;

strObj: mainMenu
    menuDesc = "\(Q\)uit"
    menuKeys = [ 'q' 'quit' ]
    menuAction( c, l, p ) = (quit())
;

    
Me: object
    status = "Merging from file:  << self.file >>"
    file = 'postemp.t'
    outputfile = ''
;

lookup: function( str ) {
    local lst := Me.symbollist, len := length( lst ), i;
    for (i := 1; i <= len; ++i)
      if (lst[i][1] = str) return lst[i][2];
    "\n<< str >>: ";
    i := inputLine();
    Me.symbollist += [[ str i ]];
    return i;
}

/*
   The codes supported by parseFile:

   !symbol1!    Find the value of symbol1 and insert it here.
   !^symbol1!   Find the value of symbol1 and insert it here, capitalising
                its first letter.
   !$string!    Display string.
   !?comment!   Comment (remove from final file).
   !!           Insert the '!' character.
 */
parseFile: function( infile, outfile ) {
    local ret, str := '', curin := 0, curout := 0, endin, cline, end, outstr;
    Me.symbollist := [];
    fseekeof( infile );
    endin := ftell( infile );
    while (curin <= endin) {
      outstr := '';
      fseek( infile, curin );
      cline := fread( infile );
      if (cline = nil) break;
      curin += length( cline );
      while (true) {
        ret := reSearch( '![^!]*!', cline );
        if (ret = nil) {
          outstr += cline;
          break;
        }
        str := substr( ret[3], 2, ret[2] - 2 );
        outstr += substr( cline, 1, ret[1] - 1 );
        if (str = '') outstr += '!';
        else {
          end := substr( str, 1, 1 );
          switch (end) {
            case '^':
              str := lookup( substr( str, 2, length( str ) - 1 ) );
              str := upper( substr( str, 1, 1 ) ) + substr( str, 2, length( str ) - 1 );
              break;
            case '$':
              "\n"; say (substr( str, 2, length( str ) - 1 ));
              str := '';
              break;
            case '?':
              str := '';
              break;
            default:
              str := lookup( str );
          }
          outstr += str;
        }
        end := ret[1] + ret[2];
        cline := substr( cline, end, length( cline ) - end + 1 );
        if (cline = '') break;
      }
      fseek( outfile, curout );
      fwrite( outfile, outstr );
      curout += length( outstr );
    }
}
