#include <adv.t>
#include <std.t>

startroom : room
  sdesc = "Cave"
  ldesc = "You are standing in a cave. The ground is quite sandy.
  In the corner of the cave, there is a trophy case here. "
;

/*
The following two lines are identical
say ('This message will be printed to the screen.');
"This message will be printed to the screen";

flashlight : lightsource
  islit = nil
  location = startroom
  noun = 'flashlight'
  sdesc = "flashlight"
  ldesc = 
  {
    if (self.islit)
    {
      "The flashlight has a switch; it is currently set to the on
      position";
    }
    else
    {
      "The flashlight has a switch; it is currently set to the off
      position";
    }
  }
;
*/

flashlight : lightsource
  islit = nil
  location = startroom
  noun = 'flashlight'
  sdesc = "flashlight"
  ldesc = "The flashlight has a switch; it is currently 
  set to the << self.islit ? "on" : "off" >> position."

  verDoTurnon(actor) =
  {
    if (not actor.isCarrying(self))
    {
      "You aren't carrying the flashlight! ";
    } 
    else if (self.islit)
    {
      "The flashlight is already on! ";
    }
  }
  doTurnon(actor) = 
  {
    "You turn on the flashlight, producing a powerful beam of light. ";
    self.islit = true;
  }
  
  verDoTurnoff(actor) = 
  {
    if (not actor.isCarrying(self))
    {
      "You aren't carrying the flashlight! ";
    }
    else if (not self.islit)
    {
      "The flashlight is already off! ";
    }
  }
  doTurnoff(actor) = 
  {
    "You turn off the flashlight, and it goes dark. ";
    self.islit = nil;
  }
;

flashlightSwitch : fixeditem
  location = flashlight
  noun = 'switch'
  adjective = 'flashlight'
  sdesc = "flashlight switch"
  ldesc = "The switch allows you turn the flashlight on or off.  The
  flashlight is currently << flashlight.islit ? "on" : "off" >>."
  doTurnon -> flashlight
  doTurnoff -> flashlight
/*
  verDoTurnon(actor) =
  {
    flashlight.verDoTurnon(actor);
  }
  doTurnon(actor) = 
  {
    flashlight.doTurnon(actor);
  }
  
  verDoTurnoff(actor) = 
  {
    flashlight.verDoTurnoff(actor);
  }
  doTurnoff(actor) = 
  {
    flashlight.doTurnoff(actor);
  }
*/
;

trophy : item
  noun = 'trophy'
  sdesc = "trophy"
  ldesc = "It's a beautiful gold trophy. "
;

trophyCase : container, fixeditem
  location = startroom
  noun = 'case'
  adjective = 'trophy'
  sdesc = "trophy case"
  
  ioPutIn (actor, dobj) = 
  {
    if (dobj == trophy)
    {
      "As you place the trophy in the case, the case briefly glows. ";
      incscore(20);
      pass ioPutIn;
    }
    else
    {
      pass ioPutIn;
    }
  }
  ioSynonym ('PutIn') = 'PutOn'
;

shovel : item
  location = startroom
  noun = 'shovel'
  sdesc = "shovel"
  ldesc = "It looks like a strong, sturdy shovel. "
  
  verIoDigWith(actor) =
  {
    if (not actor.isCarrying(self))
    {
      "You're not carrying the shovel! ";
    }
  }
  ioDigWith(actor, dobj) =
  {
    if (dobj == sand)
    {
      "You dig in the sand and discover a trophy. ";
      trophy.moveInto(actor.location);
    }
    else
    {
      "You use the shovel to dig for a while 
      in <<dobj.thedesc>>, but discover nothing. ";
    }
  }
;

sand : fixeditem
  location = startroom
  noun = 'sand'
  sdesc = "sand"
  ldesc = "The sand looks fairly soft.  You could probably dig in it if
  you had the right tool. "
  
  verDoDigWith(actor, iobj) = 
  {
    if (iobj != shovel)
    {
      "\^<<iobj.thedesc>> isn't really the appropriate tool for 
      the job. ";
    }
  }
;
  
