//
//  XTHtmlTagTests.m
//  TadsTerp
//
//  Created by Rune Berg on 22/08/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <XCTest/XCTest.h>
#import "XTHtmlTagFont.h"


@interface XTHtmlTagTests : XCTestCase

@property XTHtmlTagFont *tag;

@end


@implementation XTHtmlTagTests

- (void)setUp
{
    [super setUp];
	self.tag = [XTHtmlTagFont new];
	self.tag.closing = NO;
}

- (void)tearDown
{
    [super tearDown];
}

- (void)test_attributeAsUInt
{
	[self.tag addAttribute:@"height" value:@"3"];
	//self.tag.attributes[@"height"] = @"3";
	NSUInteger uint = [self.tag attributeAsUInt:@"height"];
	XCTAssertEqual(3, uint);
	
	[self.tag addAttribute:@"height" value:@"x"];
	//self.tag.attributes[@"height"] = @"x";
	uint = [self.tag attributeAsUInt:@"height"];
	XCTAssertEqual(0, uint);

	[self.tag addAttribute:@"height" value:@"7z"];
	//self.tag.attributes[@"height"] = @"7z";
	uint = [self.tag attributeAsUInt:@"height"];
	XCTAssertEqual(7, uint);
}

//TODO more tests...

- (void)test_attributeAsCommaSeparatedStrings_missingAttr
{
	NSArray *a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(0, a.count);
}

- (void)test_attributeAsCommaSeparatedStrings_0strings
{
	[self.tag addAttribute:@"face" value:@""];
	//self.tag.attributes[@"face"] = @"";
	NSArray *a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(0, a.count);
}

- (void)test_attributeAsCommaSeparatedStrings_1string
{
	[self.tag addAttribute:@"face" value:@"Courier"];
	//self.tag.attributes[@"face"] = @"Courier";
	NSArray *a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(1, a.count);
	XCTAssertEqualObjects(@"Courier", a[0]);
	
	[self.tag addAttribute:@"face" value:@" "];
	//self.tag.attributes[@"face"] = @" ";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(1, a.count);
	XCTAssertEqualObjects(@"", a[0]);

	[self.tag addAttribute:@"face" value:@"   "];
	//self.tag.attributes[@"face"] = @"   ";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(1, a.count);
	XCTAssertEqualObjects(@"", a[0]);
}

- (void)test_attributeAsCommaSeparatedStrings_2strings
{
	[self.tag addAttribute:@"face" value:@"Courier,Arial"];
	//self.tag.attributes[@"face"] = @"Courier,Arial";
	NSArray *a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(2, a.count);
	XCTAssertEqualObjects(@"Courier", a[0]);
	XCTAssertEqualObjects(@"Arial", a[1]);

	[self.tag addAttribute:@"face" value:@"C,A"];
	//self.tag.attributes[@"face"] = @"C,A";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(2, a.count);
	XCTAssertEqualObjects(@"C", a[0]);
	XCTAssertEqualObjects(@"A", a[1]);

	[self.tag addAttribute:@"face" value:@"C,"];
	//self.tag.attributes[@"face"] = @"C,";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(2, a.count);
	XCTAssertEqualObjects(@"C", a[0]);
	XCTAssertEqualObjects(@"", a[1]);

	[self.tag addAttribute:@"face" value:@",A"];
	//self.tag.attributes[@"face"] = @",A";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(2, a.count);
	XCTAssertEqualObjects(@"", a[0]);
	XCTAssertEqualObjects(@"A", a[1]);

	[self.tag addAttribute:@"face" value:@" Courier,Arial " ];
	//self.tag.attributes[@"face"] = @" Courier,Arial ";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(2, a.count);
	XCTAssertEqualObjects(@"Courier", a[0]);
	XCTAssertEqualObjects(@"Arial", a[1]);

	[self.tag addAttribute:@"face" value:@" Courier ,  Arial "];
	//self.tag.attributes[@"face"] = @" Courier ,  Arial ";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(2, a.count);
	XCTAssertEqualObjects(@"Courier", a[0]);
	XCTAssertEqualObjects(@"Arial", a[1]);

	[self.tag addAttribute:@"face" value:@","];
	//self.tag.attributes[@"face"] = @",";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(2, a.count);
	XCTAssertEqualObjects(@"", a[0]);
	XCTAssertEqualObjects(@"", a[1]);

	[self.tag addAttribute:@"face" value:@"  ,   "];
	//self.tag.attributes[@"face"] = @"  ,   ";
	a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(2, a.count);
	XCTAssertEqualObjects(@"", a[0]);
	XCTAssertEqualObjects(@"", a[1]);
}

- (void)test_attributeAsCommaSeparatedStrings_3strings
{
	[self.tag addAttribute:@"face" value:@"Courier,Arial,Dingbats"];
	//self.tag.attributes[@"face"] = @"Courier,Arial,Dingbats";
	NSArray *a = [self.tag attributeAsCommaSeparatedStrings:@"face"];
	XCTAssertEqual(3, a.count);
	XCTAssertEqualObjects(@"Courier", a[0]);
	XCTAssertEqualObjects(@"Arial", a[1]);
	XCTAssertEqualObjects(@"Dingbats", a[2]);
}

@end
