//
//  XTHtmlLinebreakHandler2tests.m
//  TadsTerp
//
//  Created by Rune Berg on 11/05/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <XCTest/XCTest.h>
#import "XTHtmlLinebreakHandler2.h"


@interface XTHtmlLinebreakHandler2tests : XCTestCase

@property XTHtmlLinebreakHandler2 *handler;

@end


@implementation XTHtmlLinebreakHandler2tests

- (void)setUp
{
    [super setUp];
	self.handler = [XTHtmlLinebreakHandler2 new];
}

- (void)tearDown
{
    [super tearDown];
}

//-------- state "start of line" -------------

- (void)test_atStartOfLine_Br0
{
	XCTAssertEqualObjects(@"", [self.handler handleTagBr:0]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_atStartOfLine_Br
{
	XCTAssertEqualObjects(@"\n", [self.handler handleTagBr:-1]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_atStartOfLine_Br1
{
	XCTAssertEqualObjects(@"\n", [self.handler handleTagBr:1]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_atStartOfLine_Br2
{
	XCTAssertEqualObjects(@"\n\n", [self.handler handleTagBr:2]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_atStartOfLine_Br7
{
	XCTAssertEqualObjects(@"\n\n\n\n\n\n\n", [self.handler handleTagBr:7]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_atStartOfLine_text
{
	[self.handler handleText:@"foo"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
}

- (void)test_atStartOfLine_text_2
{
	[self.handler handleText:@""];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
	[self.handler handleText:nil];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

/*- (void)test_atStartOfLine_P
{
	XCTAssertEqualObjects(@"\n", [self.handler handleTagP]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}*/

- (void)test_atStartOfLine_Tab
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
}

//-------- state "after tab at start of line" -------------

- (void)test_afterTabAtStartOfLine_text
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	[self.handler handleText:@"blah"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
}

- (void)test_afterTabAtStartOfLine_textEndingWithNewline
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	[self.handler handleText:@"blah\n"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_afterTabAtStartOfLine_Tab
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
}

- (void)test_afterTabAtStartOfLine_Br0
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagBr:0]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}
- (void)test_afterTabAtStartOfLine_Br0_plantBug
{
	[self.handler handleText:@"Mr."];
	 XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	XCTAssertEqualObjects(@"\n", [self.handler handleTagBr:0]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagBr:0]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagBr:0]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	[self.handler handleText:@"Your."];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);

	/*TODO
	 "Mr.
	 <BR HEIGHT=0>
	 <TAB MULTIPLE=4>
	 <BR HEIGHT=0>
	 <BR HEIGHT=0>
	 <TAB MULTIPLE=4>Your.";
	 */
}

- (void)test_afterTabAtStartOfLine_Br
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagBr:-1]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_afterTabAtStartOfLine_Br1
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagBr:1]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_afterTabAtStartOfLine_Br2
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"\n\n\n", [self.handler handleTagBr:2]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_afterTabAtStartOfLine_BrN
{
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"\n\n\n\n", [self.handler handleTagBr:3]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

/*- (void)test_afterTabAtStartOfLine_P
{
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AFTER_TAB_START_OF_LINE, self.handler.state);
	XCTAssertEqualObjects(@"\n", [self.handler handleTagP]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}*/

//-------- state "in text" -------------

- (void)test_inText_Br0
{
	[self.handler handleText:@"foo"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	XCTAssertEqualObjects(@"\n", [self.handler handleTagBr:0]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_inText_Br
{
	[self.handler handleText:@"foo"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	XCTAssertEqualObjects(@"\n", [self.handler handleTagBr:-1]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_inText_Br1
{
	[self.handler handleText:@"foo"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	XCTAssertEqualObjects(@"\n", [self.handler handleTagBr:1]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_inText_BrN
{
	[self.handler handleText:@"foo"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	XCTAssertEqualObjects(@"\n\n\n\n", [self.handler handleTagBr:3]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);

	XCTAssertEqualObjects(@"\n", [self.handler handleTagBr:-1]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}

- (void)test_inText_text
{
	[self.handler handleText:@"foo"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	[self.handler handleText:@"bar"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	[self.handler handleText:@""];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	[self.handler handleText:nil];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
}

/*- (void)test_inText_P
{
	[self.handler handleText:@"foo"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	XCTAssertEqualObjects(@"\n\n", [self.handler handleTagP]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_AT_START_OF_LINE, self.handler.state);
}*/

- (void)test_inText_Tab
{
	[self.handler handleText:@"foo"];
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
	XCTAssertEqualObjects(@"", [self.handler handleTagTab]);
	XCTAssertEqual(XT_LINEBREAKHANDLER2_IN_TEXT, self.handler.state);
}

//TODO test general "block level", e.g. "<br><br>"

@end
