//
//  XTConverter.m
//  TadsTerp
//
//  Created by Rune Berg on 03/04/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import "XTConverter.h"
#import "XTAllocDeallocCounter.h"


@implementation XTConverter

//TODO unit test

+ (instancetype)converter
{
	XTConverter *converter = [[XTConverter alloc] init];
	return converter;
}

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (BOOL)toUInteger:(NSString *)s uinteger:(NSUInteger *)uinteger
{
	NSScanner *scanner = [NSScanner scannerWithString:s];
	unsigned long long ull = 0;
	BOOL res = NO;
	if ([scanner scanUnsignedLongLong:&ull]) {
		if (ull <= NSUIntegerMax) {
			if ([scanner isAtEnd]) {
				*uinteger = ull;
				res = YES;
			}
		}
	}
	return res;
}

- (BOOL)toInteger:(NSString *)s integer:(NSInteger *)integer
{
	NSScanner *scanner = [NSScanner scannerWithString:s];
	long long ll = 0;
	BOOL res = NO;
	if ([scanner scanLongLong:&ll]) {
		if (ll <= NSIntegerMax) {
			if ([scanner isAtEnd]) {
				*integer = ll;
				res = YES;
			}
		}
	}
	return res;
}

@end
