//
//  XTHtmlTagTr.m
//  XTads
//
//  Created by Rune Berg on 10/07/15.
//  Copyright (c) 2015 Rune Berg. All rights reserved.
//

#import "XTHtmlTag_private.h"
#import "XTHtmlTagContainer_private.h"
#import "XTHtmlTagTable.h"
#import "XTHtmlTagTr.h"
#import "XTBaseTextHandler.h"


@implementation XTHtmlTagTr

+ (NSString *)name
{
	return @"tr";
}

+ (BOOL)standalone
{
	return NO;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	formattingSpec.tableRowIndexPlusOne += 1; // yes, must modify parent's
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	res.textAlignMode = [self getTextAlignModeWithDefault:XT_TEXT_ALIGN_UNSPECIFIED];

	return res;
}

- (void)formatExit:(NSObject<XTOutputFormatterProtocol> *)formatter
	   textHandler:(XTBaseTextHandler *)textHandler
{
	NSArray *formattedElements = [formatter handleHtmlTagTrClose:self];
	[textHandler receiveFormattedElements:formattedElements];
	
	[super formatExit:formatter textHandler:textHandler];
}

- (XTHtmlTagContainer *)findCorrectContainer:(XTHtmlTagContainer *)defaultContainer
{
	XTHtmlTagContainer *res = defaultContainer;
	
	for (XTHtmlTagContainer *container = defaultContainer;
		 container != nil;
		 container = container.container) {
		
		if ([container isKindOfClass:[XTHtmlTagTable class]]) {
			// Our nearest <table> is the one
			res = container;
			break;
		}
	}
	
	return res;
}

@end
