//
//  XTTextTable.h
//  XTads
//
//  Created by Rune Berg on 03/09/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Cocoa/Cocoa.h>
//#import "XTOutputFormatterProtocol.h"
#import "XTTextTableBlock.h"
#import "XTTextAlignMode.h"

@class XTOutputFormatterProtocol;


@interface XTTextTable : NSTextTable

@property NSNumber *tableId;

@property NSMutableArray *textTableBlocks;

@property NSInteger numberOfRows;

@property NSNumber *widthAsPercentage;

@property NSNumber *widthAsPoints;

@property (readonly) NSInteger borderSize;

//TODO !!! make r/o?
@property NSInteger cellSpacing;

@property XTTextAlignMode alignment;

- (void)addTextTableBlock:(XTTextTableBlock *)textTableBlock;

- (void)recalcCellMargins;

- (void)clear;

@end
