//
//  XTPrefsItem.h
//  XTads
//
//  Created by Rune Berg on 31/03/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTPrefsValueTransformer.h"


@interface XTPrefsItem<__covariant ObjectType> : NSObject

@property ObjectType value;
@property BOOL skipResetToDefault;

+ (instancetype)itemWithDefaultValue:(ObjectType)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey;

+ (instancetype)itemWithDefaultValue:(ObjectType)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey
					valueTransformer:(XTPrefsValueTransformer *)valueTransformer;

- (void)resetToDefaultValue;

- (ObjectType)copyOfDefaultValue;

- (void)persist;

- (void)restoreFromPersisted;

- (void) addObserver:(NSObject *)observer;

- (void) removeObserver:(NSObject *)observer;

@end
