//
//  XTFormattingSpecification.m
//  XTads
//
//  Created by Rune Berg on 02/06/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTFormattingSpecification.h"
#import "XTAllocDeallocCounter.h"


@implementation XTFormattingSpecification

+ (instancetype)specificationWithDefaults
{
	XTFormattingSpecification *spec = [XTFormattingSpecification new];
	spec.bold = NO;
	spec.italic = NO;
	spec.underline = NO;
	spec.tt = NO;
	spec.cite = NO;
	spec.code = NO;
	spec.em = NO;
	spec.strong = NO;
	spec.t2Hilite = NO;
	spec.t2Italics = NO;
	spec.htmlSize = 3;
	spec.activeTagA = nil;
	spec.htmlFontFaceList = nil;
	spec.listLevel = 0;
	spec.inListItem = NO;
	spec.inListItemAfterFirstParagraph = NO;
	spec.blockquoteLevel = 0;
	spec.inAboutBox = NO;
	spec.activeTextTable = nil;
	spec.activeTextTableCell = nil;
	spec.tableRowIndexPlusOne = 0;
	spec.tableColumnIndexPlusOne = 0;
	spec.textTableRowHtmlColor = nil;
	spec.textTableCellHtmlColor = nil;
	spec.textAlignMode = XT_TEXT_ALIGN_LEFT;
	spec.isInHeader = NO;
	spec.hasRightAlignedTab = NO;
	return spec;
}


+ (instancetype)specificationFrom:(XTFormattingSpecification *)original
{
	XTFormattingSpecification *new = [XTFormattingSpecification new];
	new.bold = original.bold;
	new.italic = original.italic;
	new.underline = original.underline;
	new.tt = original.tt;
	new.cite = original.cite;
	new.code = original.code;
	new.em = original.em;
	new.strong = original.strong;
	new.t2Hilite = original.t2Hilite;
	new.t2Italics = original.t2Italics;
	new.htmlSize = original.htmlSize;
	new.activeTagA = original.activeTagA;
	new.htmlFontFaceList = original.htmlFontFaceList;
	new.fontColor = original.fontColor;
	new.backgroundColor = original.backgroundColor;
	new.listLevel = original.listLevel;
	new.inListItem = original.inListItem;
	new.inListItemAfterFirstParagraph = original.inListItemAfterFirstParagraph;
	new.blockquoteLevel = original.blockquoteLevel;
	new.inAboutBox = original.inAboutBox;
	new.activeTextTable = original.activeTextTable;
	new.activeTextTableCell = original.activeTextTableCell;
	new.tableRowIndexPlusOne = original.tableRowIndexPlusOne;
	new.tableColumnIndexPlusOne = original.tableColumnIndexPlusOne;
	new.textTableRowHtmlColor = original.textTableRowHtmlColor;
	new.textTableCellHtmlColor = original.textTableCellHtmlColor;
	new.textAlignMode = original.textAlignMode;
	new.isInHeader = original.isInHeader;
	new.hasRightAlignedTab = original.hasRightAlignedTab;
	return new;
}

@synthesize textAlignModeAsString = _textAlignModeAsString;

OVERRIDE_ALLOC_FOR_COUNTER
OVERRIDE_DEALLOC_FOR_COUNTER

- (NSString *)textAlignModeAsString
{
	NSString *res;
	switch (self.textAlignMode) {
		case XT_TEXT_ALIGN_LEFT:
			res = @"Left";
			break;
		case XT_TEXT_ALIGN_CENTER:
			res = @"Center";
			break;
		case XT_TEXT_ALIGN_RIGHT:
			res = @"Right";
			break;
		case XT_TEXT_ALIGN_JUSTIFY:
			res = @"Justify";
			break;
		case XT_TEXT_ALIGN_UNSPECIFIED:
			res = @"Unspec.";
			break;
		default:
			res = @"???";
			break;
	}
	return res;
}

- (NSInteger)getBaseHtmlSize
{
	return 3;
		//TODO !!! baseHtmlSize can be affect by <BASEFONT>
}

- (void)resetForNextCommand
{
	self.listLevel = 0;
	self.inListItem = NO;
	//TODO probably more to be done here
}

@end
