//
//  XTPrefsItemBoolAffectingColors.m
//  XTads
//
//  Created by Rune Berg on 24/04/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import "XTPrefsItem_private.h"
#import "XTPrefsItemBoolAffectingColors.h"


@implementation XTPrefsItemBoolAffectingColors

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey;
{
	return [XTPrefsItemBoolAffectingColors itemWithDefaultValue:defaultValue userDefaultsKey:userDefaultsKey valueTransformer:nil];
}

+ (instancetype)itemWithDefaultValue:(id)defaultValue
					 userDefaultsKey:(NSString *)userDefaultsKey
					valueTransformer:(XTPrefsValueTransformer *)valueTransformer
{
	XTPrefsItemBoolAffectingColors *item = [XTPrefsItemBoolAffectingColors new];
	item.defaultValue = defaultValue;
	item.userDefaultsKey = userDefaultsKey;
	item.valueTransformer = valueTransformer;
	item.value = [item copyOfDefaultValue];
	item.skipResetToDefault = NO;
	return item;
}

@end
