//
//  XTTextTableBlock.h
//  XTads
//
//  Created by Rune Berg on 03/09/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "XTRect.h"
#import "XTHtmlColor.h"
#import "XTTextVerticalAlignMode.h"

@class XTOutputFormatterProtocol;


@interface XTTextTableBlock : NSTextTableBlock

@property NSNumber *tableId;

- (void)setWidthAsPercentage:(NSNumber *)widthAsPercentage;
- (NSNumber *)widthAsPercentage;

- (void)setWidthAsPoints:(NSNumber *)widthAsPoints;
- (NSNumber *)widthAsPoints;

- (void)setHeightAsPercentage:(NSNumber *)heightAsPercentage;
- (NSNumber *)heightAsPercentage;

- (void)setHeightAsPoints:(NSNumber *)heightAsPoints;
- (NSNumber *)heightAsPoints;

- (void)setHeightStar:(BOOL)heightStar;
- (BOOL)heightStar;

- (void)setVerticalAlignmentMode:(XTTextVerticalAlignMode)mode;

- (void)setInheritedHeadIndent:(CGFloat)inheritedHeadIndent;

- (void)setInheritedTailIndent:(CGFloat)inheritedTailIndent;

- (XTRect *)getlatestContentRect;

- (CGFloat)totalBoundsWidth;

- (CGFloat)totalBoundsWidthOnLeftHandSide;

- (void)recalcCellMargins;

- (void)setBackgroundHtmlColor:(XTHtmlColor *)htmlColor;

- (void)updateBackgroundColor;

@end
