//
//  XTDefaultColours.m
//  XTads
//
//  Created by Rune Berg on 22/12/2018.
//  Copyright © 2018 Rune Berg. All rights reserved.
//

#import "XTDefaultColours.h"


@implementation XTDefaultColours

static CGFloat maxRGB = 255.0;

// Firefox defaults:
static CGFloat lightGreyRGB = 191.0; // out of 255.0
static CGFloat greyRGB = 140.0; // out of 255.0
static CGFloat darkGreyRGB = 90.0; // out of 255.0

static NSColor *tableBorderColorLeftAndTop;
static NSColor *tableBorderColorRightAndBottom;
static NSColor *tableCellBorderColorLeftAndTop;
static NSColor *tableCellBorderColorRightAndBottom;
static NSColor *tableCellBorderColorRightAndBottom;
static NSColor *horizRulerColor;

+ (void)initialize
{
	if (self == [XTDefaultColours class]) {
		CGFloat lightGreyRGBOneToZero = lightGreyRGB / maxRGB;
		CGFloat greyRGBOneToZero = greyRGB / maxRGB;
		CGFloat darkGreyRGBOneToZero = darkGreyRGB / maxRGB;
		
		tableBorderColorLeftAndTop = [NSColor colorWithRed:lightGreyRGBOneToZero
													 green:lightGreyRGBOneToZero
													  blue:lightGreyRGBOneToZero
													 alpha:1.0];
		
		tableBorderColorRightAndBottom = [NSColor colorWithRed:darkGreyRGBOneToZero
														 green:darkGreyRGBOneToZero
														  blue:darkGreyRGBOneToZero
														 alpha:1.0];

		tableCellBorderColorLeftAndTop = [NSColor colorWithRed:darkGreyRGBOneToZero
														 green:darkGreyRGBOneToZero
														  blue:darkGreyRGBOneToZero
														 alpha:1.0];
		
		tableCellBorderColorRightAndBottom = [NSColor colorWithRed:lightGreyRGBOneToZero
															 green:lightGreyRGBOneToZero
															  blue:lightGreyRGBOneToZero
															 alpha:1.0];
		
		horizRulerColor = [NSColor colorWithRed:greyRGBOneToZero
										  green:greyRGBOneToZero
										   blue:greyRGBOneToZero
										  alpha:1.0];
	}
}

+ (NSColor *)tableBorderColorLeftAndTop
{
	return tableBorderColorLeftAndTop;
}

+ (NSColor *)tableBorderColorRightAndBottom
{
	return tableBorderColorRightAndBottom;
}

+ (NSColor *)tableCellBorderColorLeftAndTop
{
	return tableCellBorderColorLeftAndTop;
}

+ (NSColor *)tableCellBorderColorRightAndBottom
{
	return tableCellBorderColorRightAndBottom;
}

+ (NSColor *)horizRulerColor
{
	return horizRulerColor;
}

@end
