//
//  XTOutputTextColorResult.h
//  XTads
//
//  Created by Rune Berg on 29/03/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTHtmlColor.h"


//NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, XTColorSource) {
	XT_COLOR_SOURCE_OUTPUT_FROM_PREFS = 1,
	XT_COLOR_SOURCE_OUTPUT_FROM_BODY = 2,
	XT_COLOR_SOURCE_OUTPUT_FROM_FONT = 3,
	XT_COLOR_SOURCE_INPUT_FROM_PREFS = 4,
	XT_COLOR_SOURCE_INPUT_FROM_BODY = 5,
	XT_COLOR_SOURCE_BACKGROUND_FROM_FONT = 6,
	XT_COLOR_SOURCE_UNSPECIFIED = 99
};

@interface XTOutputTextColorResult : NSObject

+ (instancetype)forHtmlColor:(XTHtmlColor *)htmlColor
				 colorSource:(XTColorSource)colorSource;

+ (instancetype)forHtmlColor:(XTHtmlColor *)htmlColor
				 colorSource:(XTColorSource)colorSource
bannerTextColorFromMainAreaPrefs:(BOOL)bannerTextColorFromMainAreaPrefs;

@property (readonly) XTHtmlColor *htmlColor;

@property (readonly) XTColorSource colorSource;

@property (readonly) BOOL bannerTextColorFromMainAreaPrefs;

@end

//NS_ASSUME_NONNULL_END
