//
//  XTTextRecolorationHelper.h
//  XTads
//
//  Created by Rune Berg on 05/05/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTOutputTextColorResult.h"


//NS_ASSUME_NONNULL_BEGIN

@interface XTTextRecolorationHelper : NSObject

+ (XTTextRecolorationHelper *)forTextStorage:(NSTextStorage *)textStorage
								 isForBanner:(BOOL)isForBanner;

- (void)applyTextHtmlColor:(NSRange)range
			   colorResult:(XTOutputTextColorResult *)colorResult
			   colorSource:(XTColorSource)colorSource
			 textHtmlColor:(XTHtmlColor *)textHtmlColor
			inputHtmlColor:(XTHtmlColor *)inputHtmlColor
				forBodyTag:(BOOL)forBodyTag
				forceApply:(BOOL)forceApply
	  allowGameToSetColors:(BOOL)allowGameToSetColors;

- (void)removeTextColorsSetByGameForRange:(NSRange)range
							  colorResult:(XTOutputTextColorResult *)colorResult
							  colorSource:(XTColorSource)colorSource;

- (void)restoreTextColorsSetByGameForRange:(NSRange)range
							   colorResult:(XTOutputTextColorResult *)colorResult
							   colorSource:(XTColorSource)colorSource;

- (void)applyTextHtmlBackgroundColor:(NSRange)range
						 colorResult:(XTOutputTextColorResult *)colorResult
						 colorSource:(XTColorSource)colorSource
						  forceApply:(BOOL)forceApply
				allowGameToSetColors:(BOOL)allowGameToSetColors;

- (void)removeTextBackgroundColorsSetByGameForRange:(NSRange)range
										colorResult:(XTOutputTextColorResult *)colorResult
										colorSource:(XTColorSource)colorSource;

- (void)restoreTextBackgroundColorsSetByGameForRange:(NSRange)range
										 colorResult:(XTOutputTextColorResult *)colorResult
										 colorSource:(XTColorSource)colorSource;

- (void)updateTableColors:(NSMutableParagraphStyle *)mutPgStyle;

@end

//NS_ASSUME_NONNULL_END
