//
//  osxtads_sysinfo.m
//  XTads
//
//  Created by Rune Berg on 12/07/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "osxtads_support.h"


/* Get system information.
 */
int os_get_sysinfo( int code, void* param, long* result )
{
	XTOSIFC_DEF_SELNAME(@"os_get_sysinfo");
	XTOSIFC_TRACE_1(@"code=%d", code);
	
    switch(code)
    {
		case SYSINFO_HTML:
			*result = 1;
			break;
		case SYSINFO_JPEG:
		case SYSINFO_PNG:
			*result = 1; //TODO 0? (drool.game breed list prefixes)
			break;
		case SYSINFO_LINKS_HTTP:
		case SYSINFO_LINKS_FTP:
		case SYSINFO_LINKS_NEWS:
		case SYSINFO_LINKS_MAILTO:
		case SYSINFO_LINKS_TELNET:
			*result = 1;
			break;
		case SYSINFO_PNG_TRANS:
		case SYSINFO_PNG_ALPHA:
		case SYSINFO_OGG:
		case SYSINFO_MNG:
		case SYSINFO_MNG_TRANS:
		case SYSINFO_MNG_ALPHA:
			*result = 0;
			break;
		case SYSINFO_TEXT_HILITE:  //TODO check
			// space.t3 uses this
			*result = 1;
			break;
		case SYSINFO_BANNERS:
			*result = 1;
			break;
		case SYSINFO_WAV:
		case SYSINFO_MIDI:
		case SYSINFO_WAV_MIDI_OVL:
		case SYSINFO_WAV_OVL:
		case SYSINFO_MPEG:
		case SYSINFO_MPEG1:
		case SYSINFO_MPEG2:
		case SYSINFO_MPEG3:
		case SYSINFO_AUDIO_FADE:
		case SYSINFO_AUDIO_CROSSFADE:
		case SYSINFO_PREF_IMAGES:
		case SYSINFO_PREF_SOUNDS:
		case SYSINFO_PREF_MUSIC:
			*result = 0;
			break;
		case SYSINFO_PREF_LINKS:
			*result = 1; // displayed normally
			break;
		case SYSINFO_TEXT_COLORS:
			//TODO SYSINFO_TXC_* when allowing games to set text colour
			*result = SYSINFO_TXC_RGB; // blighted isle help uses this (Colouring Unvisited Exits)
			break;
		case SYSINFO_INTERP_CLASS:
			*result = SYSINFO_ICLASS_HTML; //SYSINFO_ICLASS_TEXTGUI; // qtads: SYSINFO_ICLASS_HTML;
			break;
		default:
			XTOSIFC_ERROR_1(@"unknown code %d", code);
			return 0;
    }
    return 1;
}

