// EIKCONCL.H
//
// Copyright (c) 1997-1999 Symbian Ltd.  All rights reserved.
//

#include <eikconso.h>
#include <eikenv.h>
#include <eikappui.h>  
#include <eikapp.h>  
#include "eikkeys.h"
#include <basched.h>
#include <apgwgnam.h>
#include "eikcmds.hrh"
#include <fbs.h>
#include <coeutils.h>
#include <CHARCONV.H>


#if !defined(__EIKCONCL_H__)
#define __EIKCONCL_H__

#if !defined(__E32CONS_H__)
#include <e32cons.h>
#endif

#if !defined(__W32STD_H__)
#include <w32std.h>
#endif
#if !defined(__EIKCONSO_H__)
#include <eikconso.h>
#endif

// new addition
//#define _DO_DEBUG_
//


class CEikConsoleScreen;
class CAdvConsoleClient;

CAdvConsoleClient *NewAdvConsole();

typedef const TAny* CATP;

class CAdvConsoleClient : public CConsoleBase
	{
public:
	~CAdvConsoleClient();
public: // from CConsoleBase
	virtual void SetAttr(int attrib);
	void Newline();
	void Read(TRequestStatus& aStatus);
	void ReadCancel();
	void Write(const TDesC& aDes);
	TPoint CursorPos() const;
	void SetCursorPosAbs(const TPoint& aPoint);
	void SetCursorPosRel(const TPoint& aPoint);
	void SetCursorHeight(TInt aPercentage);
	void SetTitle(const TDesC& aTitle);
	void ClearScreen();
	void ClearToEndOfLine();
	void ClearChars(const TRect &aRect, TUint aCharacterAttributes);
	void ScrollChars(const TRect &anArea,const TPoint &aVector);	
	TSize ScreenSize() const;
	void ScreenZoom();
	TKeyCode KeyCode() const;
	TUint KeyModifiers() const;
	virtual int KeyHit();
	void SetFont(TDesC *aFaceName, TInt aPointSize);
	TPoint PointerPos();	  // Last known pointer position.
	
public:
	friend CAdvConsoleClient* NewAdvConsole();
	CAdvConsoleClient();
private: // from CConsoleBase
	TInt Create(const TDesC& aTitle,TSize aSize);
private: // internal use only
	void SendReceive(TInt aMessage,const TAny* aParam);
	inline void SendReceive(TInt aMessage,TInt aParam) { SendReceive(aMessage,(const TAny*)aParam); }

// new addition
public:
	TInt	ConvertTo1251(const TDesC8& aSource, TDes& aDest);
	TInt	ConvertFrom1251(const TDesC& aSource, TDes8& aDest);
#ifdef _DO_DEBUG_
	void	Log(const TDesC8& aMessage)	{ iLogFile.Write(aMessage); }
#endif
//
private:
	friend class CAdvConsMessager;
	RThread iThread;
	TRequestStatus iLogonStatus;
	TRequestStatus* iThreadStatus;
	TInt* iMessage;
	CATP* iParam;
	TRequestStatus** iReplyStatus;
	TKeyEvent iKeyEvent;
	CEikConsoleScreen* iScreen;
	TBuf<20> iFaceName;
	TInt iTwipSize;
// new addition
	RFs							iFs;
	CCnvCharacterSetConverter	*iConverter;
	TUint						iCharSetWin1251;
private:
#ifdef _DO_DEBUG_
	RFile						iLogFile;
#endif
//
	};

//
// class CAdvConsMessager
//
class CAdvConsMessager : public CActive
{
public:
	CAdvConsMessager(CEikConsoleScreen* aScreen,RThread aParentThread);
	~CAdvConsMessager();
	void ConstructL(CAdvConsoleClient* aClient);
	void HandleKeyEvent(const TKeyEvent& aKeyEvent);

private: // overridden
	void RunL();
	void DoCancel();
private: // internal
	void CompleteReadRequest();
private:
	CEikConsoleScreen* iScreen;
	RThread iParentThread;
	TRequestStatus* iReadStatus;
	TKeyEvent* iKeyEvent;
	TInt iMessage;
	TPoint iPointer;
	const TAny* iParam;
	TRequestStatus* iReplyStatus;
	CCirBuf<TKeyEvent>* iKeyQ;
	TInt iZoomFactor;
	CAdvConsoleClient *iClient;
};

struct SCommandLine
{
	RThread iParentThread;
	TRequestStatus* iStatus;
	CAdvConsoleClient* iClient;
	TSize iSize;
	const TDesC* iTitle;
	const TDesC* iFaceName;
	TInt iTwipSize;
};

class CAdvConsAppUi : public CEikAppUi
{
public:
	void ConstructL(const SCommandLine* aComLine);
	~CAdvConsAppUi();
private: // overridden
//	void HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	TKeyResponse HandleKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	void HandleForegroundEventL(TBool aForeground);
	void SetAndDrawFocus(TBool aFocus);
	TBool FindFile(TDes& aFileName, const TDesC *aDefault = NULL);
private:
	CEikConsoleScreen* iScreen;
	CEikConsoleControl* iControl;
	CAdvConsMessager* iMessager;
};

//
// class CConsEikonEnv
//
class CConsEikonEnv : public CEikonEnv
{
public:
    void ConstructConsoleEnvironmentL(const SCommandLine* aComLine);
};

#endif
