//
//  XTFontManager.h
//  TadsTerp
//
//  Created by Rune Berg on 18/08/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTParameterizedFont.h"

//TODO? cache NSFont objs


@interface XTFontManager : NSObject

@property NSString *xtadsDefaultParameterizedFontName;    // xtads specific
@property NSString *xtadsFixedWidthParameterizedFontName; // xtads specific
// see http://www.tads.org/t3doc/doc/htmltads/deviate.htm Parameterized Fonts:
@property NSString *tadsSerifParameterizedFontName;       // a serifed font. This font will usually be proportionally spaced.
@property NSString *tadsSansParameterizedFontName;        // a sans serif font, usually proportionally spaced.
@property NSString *tadsScriptParameterizedFontName;      // a script or cursive font, usually proportionally spaced.
@property NSString *tadsTypewriterParameterizedFontName;  // a typewriter-style font, usually monospaced
@property NSString *tadsInputParameterizedFontName;       // a font selected by the player for command input.

// get singleton instance
+ (id)fontManager;

- (NSFont *)getFontWithParameterizedName:(NSString *)name;

- (NSFont *)getFontWithName:(NSArray *)fontNames
				  pointSize:(NSNumber *)pointSize
				   htmlSize:(NSNumber *)htmlSize
					   bold:(BOOL)bold
					italics:(BOOL)italics;

- (XTParameterizedFont *)getParameterizedFontWithName:(NSString *)parameterizedName;

- (void)setFont:(NSFont *)font forParameterizedName:(NSString *)parameterizedName;

@end
