/* $NetBSD: lex_ident.c,v 1.5 2022/04/24 09:04:12 rillig Exp $ */

/*
 * Test lexing of word-like tokens, such as keywords, identifiers, numeric
 * constants, character constants, string literals.
 */

/*
 * Conceptually, backslash-newline is replaced with nothing, in a very early
 * stage of the translation, see C11 5.1.1.2p1, item 2. Indent does not
 * preserve these; in most cases, they are simply removed.
 */
//indent input
in\
t \
var\
iable;

int
	no_backslash;

/* $ See check_size_token. */
/* $ The default buffer size is 200, the limit is 195. */
struct long_tag_name_to_overflow_the_token_buffer_4567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890;

/* $ See check_size_token. */
/* $ The difference between limit and start got incremented to 595. */
struct long_tag_name_to_overflow_the_token_buffer_4567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890\
12345678901234567890123456789012345678901234567890;
//indent end

//indent run
/* $ XXX: The indentation of the backslash is one short of a tab. */
int	       \
		variable;

int
		no_backslash;

struct long_tag_name_to_overflow_the_token_buffer_4567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890;

struct long_tag_name_to_overflow_the_token_buffer_45678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890;
//indent end


/* This is a syntax error; see lex_word. */
//indent input
int identifier\n;
//indent end

//indent run
int		identifier \ n;
//indent end
