/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.gss.util.CharConvBuilder.MappingSetter;
import oracle.sql.CharacterSet;

abstract class LCMapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    static final int LCWIDTH = 16;
    static final int LCSHIFT = 16;
    static final int LCMASK = 65535;
    static final int INVALIDLC = 65535;
    int m_l1BlockSize = 256;
    int m_ucsReplacement;
    char[] m_leadingCode;
    int m_lcCount;
    Vector[] m_mapStores;

    LCMapSetter(int n2, int n3) {
        super(n2);
        this.m_ucsReplacement = n3;
        this.m_leadingCode = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
        this.m_mapStores = new Vector[this.m_leadingCode.length];
        this.m_lcCount = 0;
    }

    void buildMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray;
        int n7;
        Vector vector;
        int n8;
        int n9 = 8;
        int n10 = 8;
        int n11 = (1 << n9) - 1;
        int n12 = (1 << n10) - 1;
        int n13 = this.m_l1BlockSize * this.m_lcCount;
        char[] cArray = new char[n13];
        char[][] cArray2 = new char[n13][2];
        int n14 = 0;
        while (n14 < n13) {
            cArray[n14] = 65535;
            cArray2[n14][0] = (char)n12;
            cArray2[n14][1] = '\u0000';
            ++n14;
        }
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        int n15 = 0;
        while (n15 < this.m_lcCount) {
            n8 = this.m_l1BlockSize * n15;
            vector = this.m_mapStores[n15];
            n7 = vector.size();
            n14 = 0;
            while (n14 < n7) {
                nArray = (int[])vector.elementAt(n14);
                n6 = nArray[1];
                if (n6 != -1) {
                    n5 = nArray[0];
                    if (hashtable.get(new Integer(n6)) == null) {
                        hashtable.put(new Integer(n6), new Integer(n5));
                    } else {
                        hashtable2.put(new Integer(n6), hashtable.get(new Integer(n6)));
                    }
                    n4 = (n5 >> n10 & n11) + n8;
                    cArray[n4] = '\u0001';
                    n3 = n5 & n12;
                    if (n3 < cArray2[n4][0]) {
                        cArray2[n4][0] = (char)n3;
                    }
                    if (n3 > cArray2[n4][1]) {
                        cArray2[n4][1] = (char)n3;
                    }
                }
                ++n14;
            }
            ++n15;
        }
        int n16 = n2 = n12 + 1;
        int n17 = 0;
        n14 = 0;
        while (n14 < n13) {
            if (cArray[n14] != '\uffff') {
                int n18 = cArray2[n14][0];
                cArray[n14] = (char)(n16 - (n17 < n18 ? n17 : n18));
                n16 = cArray[n14] + n2;
                n17 = n2 - cArray2[n14][1] - 1;
            }
            ++n14;
        }
        int[] nArray2 = new int[n16];
        n14 = 0;
        while (n14 < n16) {
            nArray2[n14] = -1;
            ++n14;
        }
        n15 = 0;
        while (n15 < this.m_lcCount) {
            n8 = this.m_l1BlockSize * n15;
            vector = this.m_mapStores[n15];
            n7 = vector.size();
            n14 = 0;
            while (n14 < n7) {
                nArray = (int[])vector.elementAt(n14);
                n6 = nArray[1];
                if (n6 != -1) {
                    n5 = nArray[0];
                    n4 = (n5 >> n10 & n11) + n8;
                    n3 = n5 & n12;
                    int n19 = cArray[n4] + n3;
                    nArray2[n19] = n6;
                }
                ++n14;
            }
            ++n15;
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setLCTable();
        this.setDuplicateMapping(hashtable2);
    }

    void finish() {
        this.buildMapping();
        super.finish();
    }

    boolean set(int n2, int n3) throws IOException {
        Vector<int[]> vector;
        int n4 = n2 >> 16 & 0xFFFF;
        int n5 = -1;
        int n6 = 0;
        while (n6 < this.m_lcCount) {
            if (n4 == this.m_leadingCode[n6]) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        if (n5 == -1) {
            if (n6 < this.m_leadingCode.length) {
                this.m_leadingCode[n6] = (char)n4;
                n5 = n6;
                this.m_lcCount = n6 + 1;
            } else {
                this.printErrorMsg("***** Error: too many leading codes: " + MappingSetter.intToHex8(n4));
                return false;
            }
        }
        if ((vector = this.m_mapStores[n6]) == null) {
            this.m_mapStores[n6] = vector = new Vector<int[]>();
        }
        n3 = (int)CharacterSet.convertUTF32toUTF16((long)n3 & 0xFFFFFFFFL);
        int[] nArray = new int[]{n2, n3};
        vector.addElement(nArray);
        return true;
    }

    abstract void setArray(char[] var1);

    abstract void setArray2(int[] var1);

    abstract void setDuplicateMapping(Hashtable var1);

    abstract void setLCTable();
}

