/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.dbaccess.DBType;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.ttc7.MAREngine;
import oracle.jdbc.ttc7.TTCItem;

public class LongTTCItem
extends TTCItem {
    private byte[] buffer = new byte[64];

    protected LongTTCItem(MAREngine mAREngine, DBType dBType) {
        super(mAREngine, dBType);
    }

    protected void marshal() throws IOException {
        if (this.isNull() || this.stream_value == null) {
            this.meg.marshalUB1((short)253);
            this.meg.marshalUB1((short)1);
        }
    }

    protected void putStream() throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getDataSize();
        if (this.isNull() || this.stream_value == null) {
            return;
        }
        this.meg.marshalUB1((short)254);
        do {
            n3 = 0;
            n2 = 0;
            while (n3 < 64 && n5 < n6) {
                n4 = 64 - n3 > n6 - n5 ? n6 - n5 : 64 - n3;
                n2 = this.stream_value.read(this.buffer, n3, n4);
                if (n2 < 0) break;
                n3 += n2;
                n5 += n2;
            }
            if (n3 <= 0) continue;
            this.meg.marshalUB1((short)(n3 & 0xFF));
            this.meg.marshalB1Array(this.buffer, 0, n3);
        } while (n2 > -1 && n5 < n6);
        this.meg.marshalSB1((byte)0);
    }

    public char[] getChars(short s2) throws SQLException {
        OracleInputStream oracleInputStream = (OracleInputStream)this.stream_value;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        int n2 = 0;
        int n3 = 0;
        if (oracleInputStream == null) {
            return null;
        }
        try {
            if (oracleInputStream.isClosed()) {
                DBError.throwSqlException(27);
            }
            while ((n2 = oracleInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
                n3 += n2;
            }
            if (n3 == 0) {
                this.is_null = true;
            }
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.data_size = byArray2.length;
        this.char_value = new char[this.data_size];
        this.char_size = this.meg.conv.CHARBytesToJavaChars(byArray2, this.data_size, this.char_value);
        return this.char_value;
    }
}

