/*
 * Decompiled with CFR 0.152.
 */
package com.jxcell.server;

import Y.C;
import com.jxcell.JCChart;
import com.jxcell.server.ChartRuntimeException;
import com.jxcell.server.I;
import com.jxcell.server.ResourceRepository;
import com.jxcell.server.Z;
import com.jxcell.server.image.J;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;

public class ChartServerComponent {
    private J EYFN = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ChartServerComponent getDefaultInstance(ServletContext servletContext) {
        ChartServerComponent chartServerComponent = (ChartServerComponent)servletContext.getAttribute("JCCHART");
        if (chartServerComponent == null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                chartServerComponent = (ChartServerComponent)servletContext.getAttribute("JCCHART");
                if (chartServerComponent == null) {
                    chartServerComponent = new ChartServerComponent();
                    servletContext.setAttribute("JCCHART", (Object)chartServerComponent);
                }
            }
        } else {
            chartServerComponent.gc();
        }
        return chartServerComponent;
    }

    public ChartServerComponent() {
        this(ResourceRepository.read());
    }

    public ChartServerComponent(J j) {
        this.EYFN = j;
    }

    public ChartServerComponent(ResourceRepository resourceRepository) {
        this.EYFN = new J(resourceRepository);
        if (resourceRepository.cache == Z.FILE) {
            resourceRepository.folders.checkImageDirectory();
        }
    }

    public final I newImageSpec() {
        return new I(this.EYFN.getProperties());
    }

    public final String getImageTag(I i, String string, String string2, boolean bl, boolean bl2) {
        return this.FILE().getImage(i, bl).getImageTag(string, string2, bl2);
    }

    public final String getImageTag(I i, String string, String string2, boolean bl) {
        return this.FILE().getImage(i, bl).getImageTag(string, string2);
    }

    public final String getImageTag(I i, String string) {
        return this.getImageTag(i, string, null, false);
    }

    public final String getImageID(I i) {
        return this.FILE().getImage(i).getID();
    }

    public final byte[] getCachedBuffer(String string) {
        return this.EYFN(this.FILE().getImage(string));
    }

    public final String getCachedImageMap(String string) {
        return this.FILE().getImage(string).getImageMap();
    }

    public final byte[] getBytes(I i) {
        return this.EYFN(this.FILE().getImage(i));
    }

    public final void saveBufferTo(I i, String string) {
        try {
            byte[] byArray = this.getBytes(i);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ChartRuntimeException(iOException);
        }
    }

    public final void gc() {
        this.FILE().gc();
    }

    public final void destroy() {
        this.FILE().destroy();
        this.EYFN = null;
    }

    public final void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public final int getImageCount() {
        return this.FILE().getImageCount();
    }

    public final long getMemorySize() {
        return this.FILE().getMemorySize();
    }

    public final String getHtmlReport() {
        return this.FILE().getHTML();
    }

    private byte[] EYFN(C c) {
        try {
            byte[] byArray = c.getBytes();
            c.free();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ChartRuntimeException(iOException);
        }
    }

    private J FILE() {
        if (this.EYFN == null) {
            throw new RuntimeException("ServerComponent is not initialized");
        }
        return this.EYFN;
    }

    public final void writeBufferTo(I i, HttpServletResponse httpServletResponse) throws IOException {
        this.Z(this.FILE().getImage(i), httpServletResponse);
    }

    public final void writeCachedBufferTo(String string, HttpServletResponse httpServletResponse) throws IOException {
        C c = this.FILE().getImage(string);
        this.Z(c, httpServletResponse);
        c.free();
    }

    private void Z(C c, HttpServletResponse httpServletResponse) throws IOException {
        byte[] byArray = c.getBytes();
        if (c.no_cache) {
            httpServletResponse.setHeader("Expires", "Sat, 01 Jan 2000 00:00:00 GMT");
            httpServletResponse.setHeader("Cache-control", "no-cache");
        }
        httpServletResponse.setContentType(this.EYFN.getProperties().mime.getMimeType(c.type));
        httpServletResponse.setContentLength(byArray.length);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.write(byArray);
        servletOutputStream.close();
    }

    public final void writeCachedBufferTo(String string, JspWriter jspWriter, HttpServletResponse httpServletResponse) throws IOException {
        byte[] byArray = this.getCachedBuffer(string);
        int n = string.lastIndexOf(46);
        String string2 = n != -1 ? string.substring(n + 1) : "gif";
        httpServletResponse.setContentType(this.EYFN.getProperties().mime.getMimeType(string2));
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (servletOutputStream != null) {
            servletOutputStream.write(byArray);
            servletOutputStream.close();
        } else {
            jspWriter.write(new String(byArray));
            jspWriter.close();
        }
    }

    public final ResourceRepository getProperties() {
        return this.EYFN.getProperties();
    }

    public final String getImageTag(JCChart jCChart, String string) {
        return this.FILE().getImage(jCChart, false).getImageTag(string, null);
    }
}

