/*
  MODULE: WS_DEBUG.C (debug routines)
*/

#include "ws_glob.h"
#include "winftp.h"

int CreateDebugWindow(HWND hMainWnd,HWND hInst)
{
  static WNDCLASS wndclass;
  long       nWndunits;     // window units for size and location
  int        nWndx;         // the x axis multiplier
  int        nWndy;         // the y axis multiplier
  int        nX;            // the resulting starting point (x, y)
  int        nY;
  int        nWidth;        // the resulting width and height for this
  int        nHeight;       // window

  wndclass.style        = CS_VREDRAW | CS_PARENTDC;
  wndclass.lpfnWndProc  = DebugWndProc;
  wndclass.cbClsExtra   = 0;
  wndclass.cbWndExtra   = 0;
  wndclass.hInstance    = hInst;
  wndclass.hIcon        = LoadIcon (hInst,"WINFTPD");
  wndclass.hCursor      = LoadCursor ((HINSTANCE) NULL, IDC_ARROW);
  wndclass.hbrBackground= GetStockObject(LTGRAY_BRUSH);
  wndclass.lpszMenuName = NULL;
  wndclass.lpszClassName= DBUGWNDCLASS;

  // Create a device independant size and location
  nWndunits = GetDialogBaseUnits();
  nWndx = LOWORD(nWndunits);
  nWndy = HIWORD(nWndunits);
  nX = ((40 * nWndx) / 4);
  nY = ((40 * nWndy) / 8);
  nWidth = ((200 * nWndx) / 4);
  nHeight = ((200 * nWndy) / 8);

  RegisterClass(&wndclass);

  hWndDbg=CreateWindow (DBUGWNDCLASS, lpDebugWindow, WS_OVERLAPPEDWINDOW,
      nX,nY,nWidth,nHeight, (HWND) NULL,(HMENU) NULL,hInst,NULL);
  ShowWindow (hWndDbg, SW_HIDE);
  return(TRUE);
}

//*******************************************************************
//*******************************************************************
void SetDebugWindowText (LPSTR lpsz)
{
  SetWindowText (hWndDbg, lpsz);
}

//*******************************************************************
//*******************************************************************
LRESULT CALLBACK DebugWndProc (HWND hWnd, UINT Message, WPARAM wParam, LPARAM lParam)
{
  // int nRC;

  switch (Message)
  {
    case WM_CREATE:
      SetScrollRange(hWnd, SB_VERT, 0, 100, FALSE);
      CheckMenuItem (GetMenu (hWnd), IDM_LOGTOFILE, nLogFlag);
      sVPos = 0;
      break;

    case WM_SETCURSOR:
      if(bCmdInProgress)
        SetCursor(hWaitCursor);
      else
        return DefWindowProc(hWnd, Message, wParam, lParam);
      break;

    case WM_PAINT:
      DoPaint((HWND)hWnd);
      break;

    case WM_VSCROLL:
      switch(wParam)
      {
        case SB_LINEDOWN:
          if(sVPos<((UINT) ptrhGMem-1)) sVPos++;
          break;
        case SB_LINEUP:
          if(sVPos>0) --sVPos;
          break;
        case SB_THUMBPOSITION:
          sVPos = (UINT) min((WORD) ptrhGMem, LOWORD(lParam));
          break;
        case SB_PAGEUP:
          if(sVPos>10) sVPos-=10; else sVPos=0;
          break;
        case SB_PAGEDOWN:
          if(sVPos<(UINT) (ptrhGMem-10)) sVPos+=10; else sVPos=ptrhGMem;
          break;
        default:
          return FALSE;
      }
      SetScrollPos(hWnd,SB_VERT,sVPos,TRUE);
      InvalidateRect(hWnd,NULL,TRUE);
      break;
    default:
      return DefWindowProc(hWnd, Message, wParam, lParam);
  }
  return 0L;
} 


