/*============================================================================
  FileO -- DLL for File Open dialog box

  File      : FileO.C

  Prototype : 

  Call      : 

  Library   : 

  24 July 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
#define WINVER 0x0300
#include <windows.h>
#include <string.h>
#include "fileo.h"

HWND   hWndMain = NULL, hWndDlg = NULL;
static HANDLE hInst;
static char szFileName[128];
static char szFileSpec[16] = "*.EXE";
static char szDefExt[5]    = "EXE";
static WORD wFileAttr      = DDL_DRIVES | DDL_DIRECTORY; /* 0x4010 */

/*============================================================================
  LibMain -- Windows calls 'LibEntry' once when the first program that
             requires the DLL is loaded.  LibEntry initializes the local
             heap by calling LocalInit and then calls LibMain.  This simply
             unlocks the data segment of the library (which is locked by
             the LocalInit call in LIBENTRY) and returns 1.

  File      : FileO.C

  Prototype : int FAR PASCAL LibMain(HANDLE, WORD, WORD, LPSTR);

  Call      : LibMain(hInstance, wDataSeg, wHeapSize, lpszCmdLine);

  Library   : 

  24 July 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
int FAR PASCAL LibMain (HANDLE hInstance, WORD wDataSeg, WORD wHeapSize,
                                                            LPSTR lpszCmdLine)
{
if (wHeapSize > 0)
   UnlockData(0);

hInst = hInstance;

return 1;
}                                       /* LibMain */

/*============================================================================
  WEP -- this is called by Windows when the dll is released

  File      : FileO.C

  Prototype : int FAR PASCAL WEP (int bSystemExit);

  Call      : (int bSystemExit);

  Library   : 

  24 July 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
int FAR PASCAL WEP (int bSystemExit)
{
/*----------------------------------------------------------------------------
  get rid of things you allocated in the LibMain proc here
----------------------------------------------------------------------------*/

return TRUE;
}                                       /* WEP */

/*============================================================================
  lstrchr --

  File      : FileO.C

  Prototype : LPSTR lstrchr(char, char);

  Call      : lstrchr(str, ch);

  Library   : 

  24 July 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
LPSTR lstrchr(LPSTR str, char ch)
{
while (*str)
   {
   if (ch == *str)
      return str;
   str = AnsiNext(str);
   }
return NULL;
}                                       /* lstrchr */

/*============================================================================
  DoFileOpenDlgProc

  File      : FileO.C

  Prototype : BOOL FAR PASCAL DoFileOpenDlgProc(HWND, WORD, WORD, LONG);

  Call      : WndProc(hWnd, message, wParam, lParam);

  Library   :

  24 July 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
BOOL FAR PASCAL DoFileOpenDlgProc(HWND hDlg, WORD message,
                                WORD wParam, LONG lParam)
{
char    cLastChar;
short   nEditLen;

switch (message)
   {
   case WM_INITDIALOG :
      SendDlgItemMessage(hDlg, IDD_FNAME, EM_LIMITTEXT, 80, 0L);
      DlgDirList(hDlg, szFileSpec, IDD_FLIST, IDD_FPATH, wFileAttr);
      SetDlgItemText(hDlg, IDD_FNAME, szFileSpec);
      return TRUE;

   case WM_COMMAND :
      switch (wParam)
         {
         case IDD_FLIST :
            switch (HIWORD(lParam))
               {
               case LBN_SELCHANGE :
                  if (DlgDirSelect(hDlg, szFileName, IDD_FLIST))
                     lstrcat(szFileName, szFileSpec);
                  SetDlgItemText(hDlg, IDD_FNAME, szFileName);
                  return TRUE;

               case LBN_DBLCLK :
                  if (DlgDirSelect(hDlg, szFileName, IDD_FLIST))
                     {
                     lstrcat(szFileName, szFileSpec);
                     DlgDirList(hDlg, szFileName, IDD_FLIST, IDD_FPATH, wFileAttr);
		               SetDlgItemText(hDlg, IDD_FNAME, szFileSpec);
                     }
                  else
                     {
                     SetDlgItemText(hDlg, IDD_FNAME, szFileName);
                     SendMessage(hDlg, WM_COMMAND, IDOK, 0L);
                     }
                  return TRUE;
               }
            break;

         case IDD_FNAME :
            if (HIWORD(lParam) == EN_CHANGE)
               EnableWindow(GetDlgItem(hDlg, IDOK),
                 (BOOL) SendMessage(LOWORD(lParam), WM_GETTEXTLENGTH, 0, 0L));
            return TRUE;

         case IDOK :
            GetDlgItemText(hDlg, IDD_FNAME, szFileName, 80);
            nEditLen = lstrlen(szFileName);
            cLastChar = *AnsiPrev(szFileName, szFileName + nEditLen);

            if (cLastChar == '\\' || cLastChar == ':')
               lstrcat(szFileName, szFileSpec);

            if (lstrchr(szFileName, '*') || lstrchr(szFileName, '?'))
               {
               if (DlgDirList(hDlg, szFileName, IDD_FLIST, IDD_FPATH, wFileAttr))
                  {
                  lstrcpy(szFileSpec, szFileName);
                  SetDlgItemText(hDlg, IDD_FNAME, szFileSpec);
                  }
               else
                  MessageBeep(0);
      
               return TRUE;
               }
            lstrcat(lstrcat(szFileName, "\\"), szFileSpec);

            if (DlgDirList(hDlg, szFileName, IDD_FLIST, IDD_FPATH, wFileAttr))
               {
               lstrcpy(szFileSpec, szFileName);
               SetDlgItemText(hDlg, IDD_FNAME, szFileSpec);
               return TRUE;
               }
            szFileName[nEditLen] = '\0';

            EndDialog(hDlg, TRUE);
            return TRUE;

         case IDCANCEL :
            EndDialog(hDlg, FALSE);
            return TRUE;
         }
   }
return FALSE;
}                                       /* DoFileOpenDlgProc */

/*============================================================================
  FileOpenDlgProc

  File      : Fileo.C

  Prototype : BOOL FAR PASCAL FileOpenDlgProc(void);

  Call      : FileOpenDlgProc()

  Library   : Fileo.DLL

  Example   : 

  26 July 1993 - dlcampbell
  (c) 1993 WynApse
----------------------------------------------------------------------------*/
BOOL FAR PASCAL FileOpenDlgProc(void)
{
static FARPROC lpfnDoFileOpenDlgProc;

lpfnDoFileOpenDlgProc = MakeProcInstance(DoFileOpenDlgProc, hInst);
DialogBox(hInst, "FILEOPEN", GetFocus(), lpfnDoFileOpenDlgProc);
FreeProcInstance(lpfnDoFileOpenDlgProc);

WritePrivateProfileString("FileO", "FileName", szFileName, "Hello.ini");
}                                       /* FileOpenDlgProc */
