/*

MET1.C - Function to load a metafile resource
         (C) 1993, Dennis CHUAH

*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <metafile.h>


HMETAFILE WINAPI LoadMetafile (HINSTANCE hInstance, LPCSTR lpMetafileName)
  {HGLOBAL handle;
   HMETAFILE hMetafile;

   handle = LoadResource (hInstance,
      FindResource (hInstance, lpMetafileName, MAKEINTRESOURCE (METAFILE)));
   if (handle == NULL) return NULL;
   if (LockResource (handle) == NULL)
     {FreeResource (handle);
      return NULL;
     }

   hMetafile = (HMETAFILE) SetMetafileBitsBetter ((HMETAFILE) handle);
   UnlockResource (handle);
   FreeResource (handle);

   return hMetafile;
  } // end LoadMetafile

