/* ------------------------------ VBTARGET.C --------------------------
 *	Target Custom Control for VB
 * ---------------------------------------------------------------- */

#include <Windows.h>
#include <vbapi.h>

#include "Target.h"
#include "VBTarget.h"

#define ERR_PF	32000

/* -------------------------- vbmSetProperty ------------------------
 *	Processes VBM_SETPROPERTY
 *		iProp (wParam) is property index
 *		lVal (lParam) is property contents
 * ---------------------------------------------------------------- */

static VOID vbmSetProperty (HCTL hCtl, HWND hWnd, WORD iProp, DWORD lVal)
{
PTARGET			pTarget;

	switch (iProp)
	{
	case IPROP_TARGET_XPOS:
	case IPROP_TARGET_YPOS:
		pTarget = VBDerefControl (hCtl);
		SendMessage (hWnd, TGM_SETPOS, 0,
					MAKELONG (VBXTwipsToPixels(pTarget->XPos),
								VBYTwipsToPixels(pTarget->YPos)));
		break;

	case IPROP_TARGET_TYPE:
		pTarget = VBDerefControl (hCtl);
		SetWindowLong (hWnd, GWL_STYLE,
			(GetWindowLong (hWnd, GWL_STYLE) & 0xFFFFFFF8L) | pTarget->Type);
		InvalidateRect (hWnd, NULL, TRUE);
		break;
	}

	return;
}

/* -------------------------- vbmCheckProperty ----------------------
 *	Processes VBM_CHECKPROPERTY
 *		iProp (wParam) is property index
 *		lVal (lParam) is property contents
 * ---------------------------------------------------------------- */

static LONG vbmCheckProperty (HCTL hCtl, HWND hWnd, WORD iProp, DWORD lVal)
{
PIC				pic;
LONG			lRet = 0;

	switch (iProp)
	{
	case IPROP_TARGET_PICTURE:
		VBGetPic ((HPIC)lVal, &pic);
		if (pic.picType == PICTYPE_BITMAP || pic.picType == PICTYPE_NONE)
		{
			SendMessage (hWnd, TGM_SETBMP,
				pic.picType == PICTYPE_BITMAP? pic.picData.bmp.hbitmap: NULL, 0L);
			InvalidateRect (hWnd, NULL, TRUE);
		}

		else
		{
			VBSetErrorMessage (ERR_PF, "Picture should be Bitmap or None");
			lRet = ERR_PF;
		}
		break;
	}

	return lRet;
}

/* -------------------------- vbnCommand ----------------------------
 *	Processes VBN_COMMAND
 * ---------------------------------------------------------------- */

static VOID vbnCommand (HCTL hCtl, HWND hWnd, int id, HWND hCtrl, int nNotify)
{
PTARGET			pTarget;
DWORD			dwPos;

	if (nNotify = TGN_CHANGE)
	{
// ---- Get new position
		dwPos = SendMessage (hWnd, TGM_GETPOS, 0, 0L);

// ---- Stores it in property structure
		pTarget = VBDerefControl (hCtl);
		pTarget->XPos = VBXPixelsToTwips (LOWORD (dwPos));
		pTarget->YPos = VBYPixelsToTwips (HIWORD (dwPos));

// ---- Fires event
		VBFireEvent (hCtl, IEVENT_TARGET_CHANGE, NULL);
	}
}

/* -------------------------- TargetCtlProc --------------------------
 *	Target Control Procedure
 * ---------------------------------------------------------------- */

LRESULT CALLBACK _export TargetCtlProc (HCTL hCtl, HWND hWnd,
								WORD wMsg, WORD wParam, LONG lParam)
{
LRESULT			lRet = 0;			// Return value
BOOL			fCallVB = FALSE;	// Indicates "Do not Call VB"

// ---- Message preprocessing
	switch (wMsg)
	{
// ---- VB Messages
	case VBM_SETPROPERTY:
		vbmSetProperty (hCtl, hWnd, wParam, lParam);
		break;

	case VBM_CHECKPROPERTY:
		lRet = vbmCheckProperty (hCtl, hWnd, wParam, lParam);
		break;

	case VBN_COMMAND:
		vbnCommand (hCtl, hWnd, wParam, LOWORD (lParam), HIWORD (lParam));
		break;

	default:
		fCallVB = TRUE;
		break;
	}

// ---- Pass Message to VB's Control Proc
	if (fCallVB)
		lRet = VBDefControlProc(hCtl, hWnd, wMsg, wParam, lParam);

	return lRet;
}
