/* Integer.c -- implementation of Integer object
 *   Provides an object that contains an int.
 */

#include "integer.h"

#define THIS    Integer
#define BASE    Object
DEFINE_CLASS(Integer,Object);

Integer::Integer(istream& strm)     { parseInteger(strm); }

unsigned Integer::hash() const    { return val; }

bool Integer::isEqual(const Object& ob) const
{
    return ob.isSpecies(class_Integer) && val==((Integer*)&ob)->val;
}

const Class* Integer::species() const { return &class_Integer; }

int Integer::compare(const Object& ob) const
{
    assertArgSpecies(ob,class_Integer,"compare");
    return val-((Integer*)&ob)->val;
}

Object* Integer::copy() const     { return shallowCopy(); }

void Integer::deepenShallowCopy()   {}

void Integer::printOn(ostream& strm) const
{
    strm << val;
}
