/**** Generalized I/O ****/

/*	Copyright (C) 1989 Massachusetts Institute of Technology
 *		Right to copy granted under the terms described
 *		in the file Copyright accompanying this distribution.
 */


#include "common.h"
#include <stdio.h>
#include <ctype.h>


#ifdef EDIT_HISTORY

Nbr Date	Author		Description
--- ----	------		-----------
 3  20-Feb-89	M. A. Patton	First release version.

#endif




char *
GetLine(fd)
FILE *fd;
{   int c;
    int char_count = 0;
    static char *buff_p = NULL;
    static int buff_size = 0;

    if (buff_p == NULL)
    {	buff_p = (char *)malloc(buff_size=80);
	if (buff_p == NULL)
	    error("Allocation error for initial buffer");
    }
    FOREVER
    {   c = getc(fd);
	if ((c==EOF) || (c=='\n'))
	{   buff_p[char_count] = '\0';
	    char_count = -1;
	    while (isspace(buff_p[++char_count]))
		;
	    if ((buff_p[char_count]=='\0') || (buff_p[char_count]==';'))
	    {   if (c==EOF) return (NULL);
		char_count = 0;
		continue;
	    }
	    return (buff_p);
	}
	if (char_count >= buff_size)
	{   buff_p = (char *)realloc(buff_p,buff_size <<= 1);
	    if (buff_p == NULL)
		error("Allocation error for input buffer");
	}
	buff_p[char_count++] = c;
    }
}
