/* pm2.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <string.h>
#define INCL_WIN
#include <os2.h>
#include "pm2.h"
#include "pmlib.h"

/* This is the maximum length of the text to be displayed. */

#define TEXT_LENGTH     64

/* This array holds the string. */

static char text_buf[TEXT_LENGTH+1];

/* This is the window handle of the client window. */

static HWND hwndMainClient;


/* This is the dialog procedure for the IDD_TEXT dialog box. */

static MRESULT EXPENTRY
TextDlgProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch (msg)
    {
    case WM_INITDLG:

      /* Initialize the dialog box.  First, remove the unwanted menu
         items of the system menu. */

      dlg_sys_menu (hwnd);

      /* Set the number of characters the entryfield can hold, put the
         current text into the entryfield, and highlight the text. */

      WinSendDlgItemMsg (hwnd, IDC_TEXT, EM_SETTEXTLIMIT,
                         MPFROMSHORT (TEXT_LENGTH), 0L);
      WinSetDlgItemText (hwnd, IDC_TEXT, text_buf);
      WinSendDlgItemMsg (hwnd, IDC_TEXT, EM_SETSEL,
                         MPFROM2SHORT (0, strlen (text_buf)), 0L);
      return (MRESULT)FALSE;

    case WM_COMMAND:

      /* Process user input. */

      switch (COMMANDMSG (&msg)->cmd)
        {
        case DID_OK:

          /* OK button.  Fetch the new text. */

          WinQueryDlgItemText (hwnd, IDC_TEXT, sizeof (text_buf), text_buf);

          /* Let the client window repaint itself. */

          WinInvalidateRect (hwndMainClient, NULL, TRUE);

          /* Done. */

          WinDismissDlg (hwnd, TRUE);
          break;
        default:

          /* Everything else: Cancel button, Close, and Esc. */

          WinDismissDlg (hwnd, FALSE);
          break;
        }
      return 0;
    }
  return (WinDefDlgProc (hwnd, msg, mp1, mp2));
}


/* This is the client window procedure for the main window. */

static MRESULT EXPENTRY
ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  HPS hps;
  RECTL rcl;

  switch (msg)
    {
    case WM_CREATE:

      /* Initialize the client window.  We just remember the window
         handle of the client window. */

      hwndMainClient = hwnd;
      return (MRESULT)FALSE;

    case WM_PAINT:

      /* Paint the client area. */

      hps = WinBeginPaint (hwnd, NULLHANDLE, NULL);
      WinQueryWindowRect (hwnd, &rcl);
      GpiSetColor (hps, CLR_DARKCYAN);
      WinDrawText (hps, -1, text_buf, &rcl, 0, 0,
                   DT_TEXTATTRS | DT_CENTER | DT_VCENTER | DT_ERASERECT);
      WinEndPaint (hps);
      return 0;

    case WM_COMMAND:

      /* Process user input. */

      switch (SHORT1FROMMP (mp1))
        {
        case IDM_EXIT:
          WinSendMsg (hwnd, WM_CLOSE, NULL, NULL);
          return (MRESULT)0;
        case IDM_TEXT:
          WinDlgBox (HWND_DESKTOP, hwnd, TextDlgProc,
                     NULLHANDLE, IDD_TEXT, NULL);
          return (MRESULT)0;
        }
      break;
    }
  return WinDefWindowProc (hwnd, msg, mp1, mp2);
}


/* The program starts here. */

int main (void)
{
  ULONG flFrameFlags;
  static char szClientClass[] = "pm2.child";
  HAB hab;
  HMQ hmq;
  HWND hwndFrame;
  QMSG qmsg;

  /* Perform PM initializations and create a message queue. */

  hab = WinInitialize (0);
  hmq = WinCreateMsgQueue (hab, 0);

  /* Set the initial string to be displayed. */

  strcpy (text_buf, "You can change this text!");

  /* Register our window class. */

  WinRegisterClass (hab, szClientClass, ClientWndProc, CS_SIZEREDRAW, 0L);

  /* Our window has a lot of frame flags set. */

  flFrameFlags = (FCF_TITLEBAR      | FCF_SYSMENU |
                  FCF_SIZEBORDER    | FCF_MINMAX  |
                  FCF_MENU          | FCF_ACCELTABLE |
                  FCF_SHELLPOSITION | FCF_ICON |
                  FCF_TASKLIST);

  /* Create our frame window. */

  hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                  &flFrameFlags, szClientClass,
                                  NULL, 0L, 0, ID_PM2, NULL);

  /* This is the message loop.  It ends when WM_QUIT is received. */

  while (WinGetMsg (hab, &qmsg, 0L, 0, 0))
    WinDispatchMsg (hab, &qmsg);

  /* Clean up. */

  WinDestroyWindow (hwndFrame);
  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);
  return 0;
}
