/* fgets.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <stdio.h>
#include <stdlib.h>
#include <emx/io.h>

char *fgets (char *buffer, int n, FILE *stream)
{
  int c;
  char *dst;

  if (n <= 0)
    return NULL;
  dst = buffer;

  STREAM_LOCK (stream);
  while (n > 1)
    {
      c = _getc_inline (stream);
      if (c == EOF)
        if (dst == buffer)
          {
            *dst = 0;
            STREAM_UNLOCK (stream);
            return NULL;
          }
        else
          break;
      *dst++ = (char)c;
      if (c == '\n')
        break;
      --n;
    }
  STREAM_UNLOCK (stream);
  *dst = 0;
  return buffer;
}
