/* heapwalk.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <stdlib.h>
#include <stddef.h>
#include <umalloc.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <emx/umalloc.h>
#include <emx/thread.h>

int _heap_walk (_um_callback1 *callback)
{
  _UM_MT_DECL
  int rc;

  /* First walk through the regular heap. */

  rc = _uheap_walk (_UM_DEFAULT_REGULAR_HEAP, callback);
  if (rc != 0)
    return rc;

  /* If there's no tiled heap or if it's identical to the regular
     heap, return the regular heap's status. */

  if (_UM_DEFAULT_REGULAR_HEAP == _UM_DEFAULT_TILED_HEAP
      || _UM_DEFAULT_TILED_HEAP == NULL)
    return rc;

  /* Walk through the tiled heap. */

  return _uheap_walk (_UM_DEFAULT_TILED_HEAP, callback);
}
