/* gettimeo.c (emx+gcc) -- Copyright (c) 1993-1996 by Eberhard Mattes */

#include <sys/timeb.h>
#include <time.h>
#include <sys/time.h>
#include <emx/time.h>
#include <emx/syscalls.h>

int _gettimeofday (struct timeval *tp, struct timezone *tzp)
{
  struct timeb tb;
  time_t t_loc;
  int dst;

  if (!_tzset_flag) _tzset ();
  __ftime (&tb);
  t_loc = tb.time;
  dst = _loc2gmt (&tb.time, -1);
  if (tp != NULL)
    {
      tp->tv_sec = tb.time;
      tp->tv_usec = tb.millitm * 1000;
    }
  if (tzp != NULL)
    {
      tzp->tz_minuteswest = (int)(tb.time - t_loc) / 60;
      tzp->tz_dsttime = dst;
    }
  return 0;
}
