/* strftime.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <locale.h>

static void usage (void)
{
  fputs ("Usage: strftime [-l <locale>] [-t]\n", stderr);
  exit (1);
}


int main (int argc, char *argv[])
{
  time_t t;
  struct tm tm, *tm_p;
  char fmt[256], buf[256], *p, *locale;
  size_t size;
  int i, table;

  locale = NULL; table = 0;

  for (i = 1; i < argc; ++i)
    if (strcmp (argv[i], "-l") == 0 && i + 1 < argc)
      locale = argv[++i];
    else if (strcmp (argv[i], "-t") == 0)
      table = 1;
    else
      usage ();

  if (locale != NULL)
    {
      if (setlocale (LC_TIME, locale) == NULL)
        printf ("setlocale failed.\n");
    }

  if (table)
    {
      tm.tm_sec = 56;
      tm.tm_min = 34;
      tm.tm_hour = 12;
      tm.tm_mday = 1;
      tm.tm_mon = 0;
      tm.tm_year = 99;
      tm.tm_yday = 0;
      tm.tm_isdst = 0;
      puts("Weekday names:");
      for (i = 0; i < 7; ++i)
        {
          tm.tm_wday = i;
          strftime (buf, sizeof (buf), "  %a %A", &tm);
          puts (buf);
        }
      puts ("Month names:");
      for (i = 0; i < 12; ++i)
        {
          tm.tm_mon = i;
          strftime (buf, sizeof (buf), "  %b %B", &tm);
          puts (buf);
        }
      tm.tm_mon = 3; tm.tm_mday = 17;
      strftime (buf, sizeof (buf), "17-Apr-1999 12:34:56 -> %c", &tm);
      puts (buf);
      strftime (buf, sizeof (buf), "17-Apr-1999          -> %x", &tm);
      puts (buf);
      strftime (buf, sizeof (buf), "12:34:56             -> %X", &tm);
      puts (buf);
      tm.tm_hour = 2;
      strftime (buf, sizeof (buf), "2 AM                 -> %I %p", &tm);
      puts (buf);
      tm.tm_hour = 14;
      strftime (buf, sizeof (buf), "2 PM                 -> %I %p", &tm);
      puts (buf);
    }
  else
    {
      time (&t);
      tm_p = localtime (&t);
      for (;;)
        {
          printf ("Format: "); fflush (stdout);
          if (fgets (fmt, sizeof (fmt), stdin) == NULL)
            return 0;
          p = strchr (fmt, '\n');
          if (p != NULL) *p = 0;
          size = strftime (buf, sizeof (buf), fmt, tm_p);
          if (size == 0)
            printf ("Error!\n");
          else
            printf ("%u: |%s|\n", (unsigned)size, buf);
        }
    }
  return 0;
}
