
sub fatal
{
    print STDERR "embed.pl: Fatal Error\n";
    printf STDERR @_;
    exit 1;
}

do fatal("Usage: embed.pl [textfile]\n") if (@ARGV != 1);
$filename = $ARGV[0];
open(FILE, $filename);
open(OUT, ">" . $filename . ".c");
$prefix = "char *embedded_text_$filename[] = {\n\t\"";
while(<FILE>) {
    print OUT $prefix;
    s/[\r\n]+//g;
    s/"/\\"/g;
    print OUT $_;
    $prefix = "\",\n\t\"";
}
print OUT "\"\n};\n";
print OUT "int embedded_text_" . $filename . "_count = " .
"sizeof(embedded_text_$filename) / sizeof(*embedded_text_$filename);\n";
close(FILE);
close(OUT);

0;
