
/*
     Program PM-Info: a program for viewing GNU-style hypertext info
     documentation files.
     Copyright (C) 1992,1993  Colin Jensen
     
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     Contact addresses:
	Colin Jensen
	email: cjensen@ampex.com or ljensen@netcom.netcom.com
	US mail: 4902 Esguerra Terrace, Fremont CA, 94555
*/

/* Work around for gcc 2.3.3 bug */
#define protected public

class StdDialogItemClass;

class StdDialogBaseClass
{
    StdDialogItemClass *item_list;
    int is_hwnd_availible;
    HWND current_hwnd;
protected:
    friend StdDialogItemClass;
    void RegisterItem(StdDialogItemClass *item);
public:
    int hwnd_availible() { return is_hwnd_availible; }
    HWND hwnd() { return current_hwnd; }
    StdDialogBaseClass();
    MRESULT message(HWND win, int msg, MPARAM mp1, MPARAM mp2);
};

extern void *object_to_call;

#define DECLARE_METHOD(method_name, return_type, param_list)		      \
static return_type method_name##_translator param_list;			      \
return_type method_name param_list;

#define DECLARE_ORIGINAL_METHOD(method_name, return_type, param_list) 	      \
return_type (*method_name##_ptr) param_list;				      \
void *method_name##_object_ptr;

#define DEFINE_METHOD(class_name, method_name, return_type, param_list,       \
		      arg_list)						      \
return_type class_name::method_name##_translator param_list		      \
{									      \
    return ((class_name *)object_to_call)->method_name arg_list;	      \
}

#define DEFINE_VOID_METHOD(class_name, method_name, param_list,		      \
		      arg_list)						      \
void class_name::method_name##_translator param_list			      \
{									      \
    ((class_name *)object_to_call)->method_name arg_list;		      \
}

#define CALL_METHOD(object_name, method_name, param_list)		      \
({									      \
    object_to_call = object_name->method_name##_object_ptr;		      \
    object_name->method_name##_ptr param_list;				      \
})

#define OVERRIDE_METHOD(method_name)					      \
method_name##_ptr = method_name##_translator;				      \
method_name##_object_ptr = this;

class StdDialogItemClass
{
public:
    StdDialogItemClass *next;
    const int dialog_id;
    StdDialogBaseClass *const dialog_base;
    MRESULT SendMsg(int msg, MPARAM mp1, MPARAM mp2);
    DECLARE_METHOD(message, MRESULT, (int msg, MPARAM mp1, MPARAM mp2, 
				      int *accept_msg));
    DECLARE_ORIGINAL_METHOD(message, MRESULT, (int msg, MPARAM mp1, 
					       MPARAM mp2, int *accept_msg));
    StdDialogItemClass(int adialog_id, StdDialogBaseClass *adialog_base);
};

class StdDialogInitClass: public StdDialogItemClass
{
    DECLARE_METHOD(message, MRESULT, (int msg, MPARAM mp1, MPARAM mp2, 
				      int *accept_msg));
public:
    virtual void dialog_init();
    StdDialogInitClass(StdDialogBaseClass *adialog_base);
};

class StdDialogClass: public StdDialogBaseClass, public StdDialogInitClass
{
    static StdDialogClass *current_dialog;
    static MRESULT message_thunk(HWND win, int msg, MPARAM mp1, MPARAM mp2);
public:
    void ExecDialog(HWND owner);
    const int dialog_id;
    StdDialogClass(int adialog_id);
};


class StdMessageItemClass: public StdDialogItemClass
{
private:
    const int message_id;
    DECLARE_METHOD(message, MRESULT, (int msg, MPARAM mp1, MPARAM mp2, 
				      int *accept_msg));
public:
    DECLARE_METHOD(cmd_message, void, ());
    DECLARE_ORIGINAL_METHOD(cmd_message, void, ());
    StdMessageItemClass(StdDialogBaseClass *adialog_base, int amessage_id);
};

class StdOKMessageItemClass: public StdMessageItemClass
{
private:
    DECLARE_METHOD(cmd_message, void, ());
public:
    virtual void ok_message() = 0;
    StdOKMessageItemClass(StdDialogBaseClass *adialog_base);
};

class StdCancelMessageItemClass: public StdMessageItemClass
{
private:
    DECLARE_METHOD(cmd_message, void, ());
public:
    virtual void cancel_message() = 0;
    StdCancelMessageItemClass(StdDialogBaseClass *adialog_base);
};

class StdListBoxItemClass: public StdDialogItemClass
{
protected:
    DECLARE_METHOD(message, MRESULT, (int msg, MPARAM mp1, MPARAM mp2, 
				      int *accept_msg));
protected:
    DECLARE_ORIGINAL_METHOD(select, void, ());
    DECLARE_METHOD(select, void, ());
    void insert(int index, const char *text);
    void insert_at_end(const char *text);
    void insert_order_ascending(const char *text);
    void insert_order_descending(const char *text);
    void select_item(int index);
    void delete_all();
    int query_selection_exists();
    int query_selection();
    char *query_item_text(int item); 
    char *query_selection_text(); // Mallocs a new string, NULL if no selection
public:
    StdListBoxItemClass(int adialog_id, StdDialogBaseClass *adialog_base);
};


class StdComboBoxItemClass: public StdListBoxItemClass
{
private:
    DECLARE_METHOD(message, MRESULT, (int msg, MPARAM mp1, MPARAM mp2,
				      int *accept_msg));
    DECLARE_METHOD(entry_field_changed, void, ());
protected:
    DECLARE_ORIGINAL_METHOD(entry_field_changed, void, ());
public:
    StdComboBoxItemClass(int adialog_id, StdDialogBaseClass *adialog_class);
};

#undef protected
