#include <stdio.h>
#define INCL_DOSPROCESS
#include <os2.h>

#define countof(a) (sizeof(a) / sizeof(a[0]))

static const char *progtable[] = {
    "gcc",	/* Gcc driver program */
    "cpp",	/* C/C++ Preprocessor */
    "cc1",	/* ANSI C Compiler */
    "cc1plus",	/* C++ Compiler */
#if 0 /* Not any more! */
    "collect",	/* C++ Constructor/Destructor link aid */
#endif
    "ld",	/* Un*x linker emulation for link386 */
    "as",	/* Assembler */
#if 0 /* Folded into as.exe */
    "o2obj",	/* A.out -> OMF object code converter */
#endif
    "link386"	/* OS/2 linker */
};

static pid[countof(progtable)];

static int loadit(const char *progname)
{
    RESULTCODES result;
    unsigned rc;
    char buf[strlen(progname)+6];
    sprintf(buf, "%s.exe", progname);
    buf[strlen(buf)+1] = '\0';
    printf("Loading `%s'...", progname);
    fflush(stdout);
    rc = DosExecPgm(0, 0, EXEC_LOAD, buf, 0, &result, buf);
    if (rc == 0) {
	printf("ok\n");
	return result.codeTerminate;
    } else {
	printf("FAILED.  Error=%d\n", rc);
	return -1;
    }
}

static void killit(int pid, const char *program)
{
    unsigned rc;
    if (pid == -1) return;
    printf("Unloading `%s'...", program);
    fflush(stdout);
    rc = DosKillProcess(DKP_PROCESS, pid);
    if (rc == 0) {
	printf("done\n");
    } else {
	printf("error %d\n", rc);
    }
}

int main()
{
    int i, c;
    for (i=0; i < countof(progtable); i++)
	pid[i] = loadit(progtable[i]);
    printf("Press <ENTER> to unload programs...");
    fflush(stdout);
    while((c = getchar()) != '\n');
    printf("Terminating...\n");
    for (i=0; i < countof(progtable); i++)
	killit(pid[i], progtable[i]);
    return 0;
}
