/**********************************************************************
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: musicout.c,v 1.3 1995/04/06 05:01:42 rowlands Exp $
 *
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
 *
 * $Log: musicout.c,v $
 * Revision 1.3  1995/04/06  05:01:42  rowlands
 * Ran decoder through protoize to convert to ANSI C.
 *
 * Revision 1.2  1995/04/06  04:56:00  rowlands
 * Added header, RCS info and cleaned up prototypes in initial revision.
 *
 **********************************************************************/

/**********************************************************************
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
 *   date   programmers                comment                        *
 * 2/25/91  Douglas Wong        start of version 1.0 records          *
 * 3/06/91  Douglas Wong        rename setup.h to dedef.h             *
 *                              removed extraneous variables          *
 *                              removed window_samples (now part of   *
 *                              filter_samples)                       *
 * 3/07/91  Davis Pan           changed output file to "codmusic"     *
 * 5/10/91  Vish (PRISM)        Ported to Macintosh and Unix.         *
 *                              Incorporated new "out_fifo()" which   *
 *                              writes out last incomplete buffer.    *
 *                              Incorporated all AIFF routines which  *
 *                              are also compatible with SUN.         *
 *                              Incorporated user interface for       *
 *                              specifying sound file names.          *
 *                              Also incorporated user interface for  *
 *                              writing AIFF compatible sound files.  *
 * 27jun91  dpwe (Aware)        Added musicout and &sample_frames as  *
 *                              args to out_fifo (were glob refs).    *
 *                              Used new 'frame_params' struct.       *
 *                              Clean,simplify, track clipped output  *
 *                              and total bits/frame received.        *
 * 7/10/91  Earle Jennings      changed to floats to FLOAT            *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced functions are        *
 *                              buffer_CRC and recover_CRC_error      *
 *                              Additions and revisions are marked    *
 *                              with "dhl" for clarity                *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *  Version 1.0                                                       *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *                                                                    *
 *                  thanks to                                         *
 *                  Ralf Schwalbe,    Telekom FTZ Berlin              *
 *                  Heiko Purnhagen,  Uni Hannover                    *
 *                                                                    *
 *  Version 2.0                                                       *
 *                                                                    *
 *  8/27/93        Susanne Ritscher, IRT Munich                       *
 *                 Channel-Switching is working                       *
 *                                                                    *
 *  Version 2.1                                                       *
 *                                                                    *
 *  9/1/93         Susanne Ritscher,  IRT Munich                      *
 *                 all channels normalized                            *
 *                                                                    *
 *  Version 3.0                                                       *
 *                                                                    *
 *  06/16/94       Ralf Schwalbe, Telekom FTZ Berlin                  *
 *                 all sources and variables adapted due to MPEG-2 -  *
 *                 DIS from March 1994                                *
 *                  - dematrix and denormalize procedure              *
 *                  - new tc - allocation (0-7)                       *
 *                  - some new structures and variables as a basis    *
 *                    for further decoding modes                      *
 **********************************************************************
 *								      *
 *  Version 1.0 Shareware                                             *
 *                                                                    *
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *								      *
 *  04/11/94	   Ralf Schwalbe. Telekom FTZ Berlin                  *
 *                  - decoding extension bitstream                    *
 *                  - some new subroutines, globale variables and     *
 *                    structures (important to handle the ext. bitst.)*
 *                  - changed all functions to ANSI-C funktion header *
 *		    - corrected some bugs to decode bitstreams > 512kB*
 *								      *
 *  Version 1.1 Shareware                                             *
 *                                                                    *
 *  07/12/94       Ralf Schwalbe,  Telekom FTZ Berlin                 *
 *                 Tel: +49 30 6708 2406                              *
 *                 Fax: +49 30 6774 539                               *
 *								      *
 **********************************************************************/

#include        "common.h"
#include        "decoder.h"

/********************************************************************
*
*        This part contains the MPEG I / II decoder for Layers II.
*
*        Core of the Layer II decoder.  Default layer is Layer II.
*
*********************************************************************/

/* Global variable definitions for "musicout.c" */

char 		   *programName;
int 		   bits_in_frame = 0;
int		   read_ext_header = 0;
int		   read_from_ext = 0,ext_error=0;
unsigned long	   frameNum = 0L;
unsigned char	   bs_tmp_buf[50];
layer 		   info;
Bit_stream_struc   bs_ext;


/* Implementations */

main(int argc, char **argv)
{
typedef long PCM[5][3][SBLIMIT];		
	PCM  *pcm_sample;
	PCM  *pcm_sample_test;					/* 10/03/1995 JMZ Multilingual*/
typedef unsigned int SAM[5][3][SBLIMIT];	
	SAM  *sample;
	SAM  *sample_test;						/* 10/03/1995 JMZ Multilingual*/
typedef double FRA[5][SBLIMIT][3][12];      /* 7.10.93 R.S. mem - alloc for DOS */ 
	FRA  *fraction;
	FRA  *fraction_test;					/*JMZ 09/03/1995 Multilingual */
typedef double FRA_HELP[12][5][3][SBLIMIT];	/* 10/03/1995 JMZ Multilingual*/
	FRA_HELP *fraction_help;
	FRA_HELP *fraction_help_test;
typedef double FRA_BUF[2][8][36+PREDDEL];   
	FRA_BUF  *pred_buf; 
typedef double VE[5][HAN_SIZE];		
	VE  *w;

	Bit_stream_struc  bs;
	frame_params      fr_ps;
	FILE              *musicout;
	FILE              *musicout_ml;			/* 10/03/1995 JMZ Multilingual*/
	unsigned long     sample_frames;
	unsigned long     sample_frames_test;
	int		  i,jj, j, k, ii, stereo, done=FALSE, clip, sync,f, mc_channel=0;
	int               error_protection, crc_error_count, total_error_count;
	int               crc_check = 1,crc_error_countmc, total_error_countmc;
	unsigned int      old_crc, new_crc;
	unsigned int      bit_alloc[5][SBLIMIT], scfsi[5][SBLIMIT],
			  scale_index[5][3][SBLIMIT]; 
	unsigned int      bit_alloc_test[5][SBLIMIT], scfsi_test[5][SBLIMIT],
			  scale_index_test[5][3][SBLIMIT]; /* 09/03/1995 JMZ Multilingual */
	unsigned long     bitsPerSlot, samplesPerFrame;
	unsigned long     frameBits, gotBits = 0;
	IFF_AIFF          pcm_aiff_data;
	char 	      	  encoded_file_name[MAX_NAME_SIZE];
	char 	      	  encoded_file_name1[MAX_NAME_SIZE]; /* 8/11/92.sr*/
	char              decoded_file_name[MAX_NAME_SIZE];
	char              decoded_file_name_ml[MAX_NAME_SIZE];/* 10/03/1995 JMZ Multilingual*/
	char		  ext_bitstream_name[MAX_NAME_SIZE];
	char		  frame_name[MAX_NAME_SIZE];
	char              t[50];
	int               need_aiff;
	int		  topSb = 0;
	int		  l, m, print_out = 0;
	
/*****************************************************************************/
	int hi, hu, ho;
	FILE *fp1;
	FILE *fp2;
	FILE *fp3;
	FILE *fp4;
/******************************************************************************/

	/* Most large variables are declared dynamically to ensure
	   compatibility with smaller machines */

	pcm_sample = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
	pcm_sample_test = (PCM *) mem_alloc((long) sizeof(PCM), "PCM Samp");
	sample 	   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
	sample_test   = (SAM *) mem_alloc((long) sizeof(SAM), "Sample");
	fraction   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
	fraction_test   = (FRA *) mem_alloc((long) sizeof(FRA), "fraction");  /* R.S. */
	fraction_help = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
	fraction_help_test = (FRA_HELP *) mem_alloc((long) sizeof(FRA_HELP), "fraction");
	pred_buf  = (FRA_BUF *) mem_alloc((long) sizeof(FRA_BUF), "pred_buf");
				
	for(k=0; k<2; k++)
	  for(ii=0; ii<8; ii++)
	    for(j =0; j <36+PREDDEL; j++)
	      (*pred_buf)[k][ii][j] = 0.0; /* clean field for starting */

	w = (VE *) mem_alloc((long) sizeof(VE), "w");

	fr_ps.header = &info;
	fr_ps.tab_num = -1;                /* no table loaded */
	fr_ps.alloc = NULL;
	info.mode_ext = 0;
	info.version = MPEG_AUDIO_ID;
	info.bitrate_index = 0;
	info.bitrate_index1 = 0;
	info.bitrate_index2 = 0;
	info.lfe = 0;	    		   /* no low frequency effect channel present! */
	info.no_of_multi_lingual_ch = 0;   /* not done yet */
	info.multi_lingual_fs = 0;         /* dto */
	info.multi_lingual_layer = 0;      /* dto */
	info.ext_bit_stream_present = 0;
	info.n_ad_bytes = info.ad_bytes_crc_info = 0;    /* 7.12.94 R.S. */

	for (i=0;i<HAN_SIZE;i++) for (j=0;j<5;j++) (*w)[j][i] = 0.0;

#ifdef CONCAT
/* 23/03/1995 JMZ Concat */
    open_bit_stream_w(&bs_concat, "toto.mpg", BUFFER_SIZE);
#endif CONCAT	

	program_information();
	programName = argv[0];
	if(argc==1)
	{        /* no command line args -> interact */
	   do
	   {
		  printf ("Enter encoded file name <required>: ");
		  gets (encoded_file_name);
		  f = strlen(encoded_file_name)-4;	  /*cut off extension.8/11/92.sr*/
		  if (encoded_file_name[0] == NULL_CHAR)
			 printf ("Encoded file name is required. \n");
	   } while (encoded_file_name[0] == NULL_CHAR);

	   printf (">>> Encoded file name is: %s \n", encoded_file_name);
	   strcpy(encoded_file_name1, encoded_file_name);  /*8/11/92.sr*/
	   strcpy(&encoded_file_name1[f], DFLT_OPEXT);	  /*.dec-extension.8/11/92.sr*/
	   printf ("Enter MPEG decoded file name <%s>: ", encoded_file_name1);
	   gets (decoded_file_name);
	   if (decoded_file_name[0] == NULL_CHAR)
		strcpy(decoded_file_name, encoded_file_name1);

/* JMZ 10/03/1995 Multilingual */
		strcpy(decoded_file_name_ml, decoded_file_name);
		strcat(decoded_file_name_ml, ".ml");
/* JMZ 10/03/1995 Multilingual */

	   printf (">>> MPEG decoded file name is: %s \n", decoded_file_name);

           /* encoded_file_name1 only for help */
	   strcpy(encoded_file_name1, encoded_file_name);
	   strcpy(&encoded_file_name1[f], DFLT_OPEXT_EXT);	  /* .ext */
	   printf (">>> Enter MPEG 2 decoded extension filename <%s>: ", encoded_file_name1);
	   gets(ext_bitstream_name);
	   if( ext_bitstream_name[0] == NULL_CHAR )
		strcpy(ext_bitstream_name, encoded_file_name1);
	   printf("Extension bitstream <%s> will be decoded \n",ext_bitstream_name);
	   if((open_bit_stream_r(&bs_ext, ext_bitstream_name, BUFFER_SIZE))==0)
		printf("No extension bitstream <%s> present \n",ext_bitstream_name);

	   printf("Do you wish to write an AIFF compatible sound file ? (<y>/n) : ");
	   gets(t);
	   if (*t == 'N' || *t == 'n') need_aiff = FALSE;
	   else                        need_aiff = TRUE;
	   if (need_aiff)
		printf(">>> An AIFF compatible sound file will be written\n");
	   else printf(">>> A non-headered PCM sound file will be written\n");
	   
	   printf("Do you want to print out all decoding information ? (<y>/n) :");
	   gets(t);
	   if( *t == 'n' || *t == 'N' ) print_out = 0;
	   else		      		print_out = 1;

	   printf("Decode with CRC - Check ? (<y>/n) :");
	   gets(t);
	   if( *t == 'n' || *t == 'N')
			crc_check = 0;
	   else
			crc_check = 1;         /*mc-crc is not ignored*/

	   printf(
		  "Do you wish to exit (last chance before decoding) ? (y/<n>) : ");
	   gets(t);
	   if (*t == 'y' || *t == 'Y') exit(0);
	}

	else	/************** interpret CL Args *****************/
		/* default: -write an AIFF file
	 		    -don't print encoded bitstream information  */
	{        
	   int i=0, err=0;

	   need_aiff = TRUE;
	   print_out = 0;

	   encoded_file_name[0] = '\0';
	   decoded_file_name[0] = '\0';
	   ext_bitstream_name[0] = '\0';

	   while(++i<argc && err == 0)
	   {
		  char c, *token, *arg, *nextArg;
		  int  argUsed;

		  token = argv[i];
		  if(*token++ == '-')
		  {
			 if(i+1 < argc) nextArg = argv[i+1];
			 else           nextArg = "";
			 argUsed = 0;
			 while((c = *token++) != 0)
			 {
				if(*token /* NumericQ(token) */) arg = token;
				else                             arg = nextArg;
				switch(c)
				{
				   case 'i':  print_out = 1; break;
					    					      break;
				   case 'a':  need_aiff = FALSE; break;
				   default:   fprintf(stderr,"%s: unrecognized option %c\n",
							  programName, c);
					      err = 1; break;
				}
				if(argUsed)
				{
					if(arg == token) token = ""; /* no more from token */
					else  ++i; /* skip arg we used */
					arg = ""; argUsed = 0;
				}
			 }
	  }
	  else
	  {
	     if(encoded_file_name[0] == '\0')
		strcpy(encoded_file_name, argv[i]);
	     else
		if(decoded_file_name[0] == '\0')
		   strcpy(decoded_file_name, argv[i]);
		else
		{
		   fprintf(stderr,"%s: excess arg %s\n", programName, argv[i]);
		   err = 1;
		}
	  }
       }
       if(err || encoded_file_name[0] == '\0') usage();  /* never returns */
       if(ext_bitstream_name[0] == '\0')
       {
	  f = strlen(encoded_file_name)-4;
	  strcpy(ext_bitstream_name, encoded_file_name);
	  strcpy(&ext_bitstream_name[f], DFLT_OPEXT_EXT);
	  if((open_bit_stream_r(&bs_ext, ext_bitstream_name, BUFFER_SIZE))==0)
		printf("No extension bitstream <%s> present \n",ext_bitstream_name);


       }

       if(decoded_file_name[0] == '\0')
       {
	  f = strlen(encoded_file_name)-4;
	  strcpy(decoded_file_name, encoded_file_name);
	  strcpy(&decoded_file_name[f], DFLT_OPEXT);
       }

    }
	/* report results of dialog / command line */
    printf("Input file = '%s' \nOutput file = '%s' ",
		   encoded_file_name, decoded_file_name);
    if(ext_bitstream_name[0] == '\0')
    	printf("Ext_bitstream = '%s'\n", ext_bitstream_name);
	  

    if(need_aiff) printf("Output file written in AIFF format\n");

    if ((musicout = fopen(decoded_file_name, "w+b")) == NULL)
    {
	   printf ("Could not create \"%s\".\n", decoded_file_name);
	   exit(0);
    }

    if ((musicout_ml = fopen(decoded_file_name_ml, "w+b")) == NULL)
    	{
	   printf ("Could not create \"%s\".\n", decoded_file_name);
	   exit(0);
    	}

    total_error_countmc = 0;
    if(open_bit_stream_r(&bs, encoded_file_name, BUFFER_SIZE) == 0)
	exit(0);

    if (need_aiff)
	  if (aiff_seek_to_sound_data(musicout) == -1)
	  {
		  printf("Could not seek to PCM sound data in \"%s\".\n",
				 decoded_file_name);
		  exit(0);
	   }

    sample_frames = 0;
    sample_frames_test = 0;

    while (!end_bs(&bs))
    {

#ifdef CONCAT    
/*		strcpy(frame_name, "frame.");
		sprintf(frame_name_ext, frameNum);
		strcat(frame_name, frame_name_ext);
    open_bit_stream_w(&bs_concat, frame_name, BUFFER_SIZE);*/
#endif CONCAT

	   sync = seek_sync(&bs, SYNC_WORD, SYNC_WORD_LNGTH);
	   frameBits = sstell(&bs) - gotBits;
	   if(frameNum > 0)        /* don't want to print on 1st loop; no lay */
		  if(frameBits%bitsPerSlot)
			 fprintf(stderr,"Got %ld bits = %ld slots plus %ld\n",
					 frameBits, frameBits/bitsPerSlot, frameBits%bitsPerSlot);
	   gotBits += frameBits;

	   if (!sync)
	   {
		  printf("\nFrame cannot be located, end of input stream \n");
		  done = TRUE;
		  /* finally write out the buffer */
		  if (info.lay == 2) 
			{
		  			out_fifo(*pcm_sample, 3, &fr_ps, done,
					      musicout, &sample_frames);
					out_fifo_test(*pcm_sample_test, 3, &fr_ps, done, musicout_ml, &sample_frames_test);
			}

		  else               out_fifo(*pcm_sample, 1, &fr_ps, done,
					      musicout, &sample_frames);
		  break;
	   }

	   decode_info(&bs, &fr_ps);
	   hdr_to_frps(&fr_ps);
	   stereo = fr_ps.stereo;
	   error_protection = info.error_protection;
	   crc_error_count = 0;
	   total_error_count = 0;
	   if(frameNum == 0) WriteHdr(&fr_ps, stdout);  /* printout layer/mode */
	   if(frameNum == 1) printf(" mc-channel=%d, MPEG2-ext-length=%d \n", mc_channel, info.ext_length*8/24);
	   fprintf(stderr, "{%4lu}\r", frameNum++); fflush(stderr);
	   if (error_protection) buffer_CRC(&bs, &old_crc);

	   switch (info.lay)
	   {

/*         case 1:  Layer I  30.05.1994  Ralf Schwalbe cut out Layer I
			     in case of multi - channel coding */

	   case 2:
		  {
			 bitsPerSlot = 8;        samplesPerFrame = 1152;
			 l = 0;                  m = stereo;
			 II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &l, &m);
			 II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &l, &m);

			 if (error_protection) {
				II_CRC_calc(&fr_ps, bit_alloc, scfsi, &new_crc);
				if (new_crc != old_crc)
				{
				   printf(" \n ERROR in LAYER 2 - CRC! \n");
				   crc_error_count++;
				   total_error_count++;
				   recover_CRC_error(*pcm_sample, crc_error_count,
									 &fr_ps, musicout, &sample_frames);
				}
				else crc_error_count = 0;
			 }

			 clip = 0;

			 for (i=0;i<12;i++)
			 {
				II_buffer_sample(&bs,(*sample),bit_alloc,&fr_ps);
				II_dequantize_sample((*sample),bit_alloc,*fraction,&fr_ps, &i);
				II_denormalize_sample(*fraction,scale_index,&fr_ps,i>>2, &i);

				if(topSb>0)         /*debug : clear channels to 0  */
				   for(j=topSb; j<fr_ps.sblimit; ++j)
					  for(k=0; k<stereo; ++k)
						 (*fraction)[i][k][0][j] =
						 (*fraction)[i][k][1][j] =
						 (*fraction)[i][k][2][j] = 0;

			 }   /* end of for loop */

		 /**********************************************************/
		 /*                                                        */
		 /*     	multichannel - decoding    	           */
		 /*             7.07.93 Susanne Ritscher                   */
		 /*            13.10.93 Ralf Schwalbe                      */
		 /*	       30.05.94 Ralf Schwalbe			   */
		 /**********************************************************/

		  mc_header(&bs, &fr_ps);
		  

		  hdr_to_frps(&fr_ps);
		  mc_channel = fr_ps.mc_channel;
		  crc_error_count = 0;
		  total_error_count = 0;
		  buffer_CRC(&bs, &old_crc);   /* read CRC - check from header */
		  mc_composite_status_info(&bs, &fr_ps);
		  /* hdr_to_frps(&fr_ps); */

		  fr_ps.jsbound = 27;
		  l = 2;
		  m = stereo + mc_channel;

		  II_decode_bitalloc(&bs, bit_alloc, &fr_ps, &l, &m);
		  II_decode_scale(&bs, scfsi, bit_alloc, scale_index, &fr_ps, &l, &m);


		  if (crc_check)
		  {
			mc_error_check(&fr_ps, bit_alloc, scfsi, &new_crc);
			if (new_crc != old_crc)
			{
				crc_error_count++;
				total_error_countmc++;
				for( i = 0; i < SBLIMIT; i ++)
					for(ii = 2; ii < 5; ++ii)
						bit_alloc[ii][i] = 0;
				mc_channel = 3;
				fr_ps.mc_channel = 3;
				printf("\nERROR in MC-CRC -> mc frame can't be decoded !\n");
			}
			else
				crc_error_count = 0;
		  } /* endif crc_check */

			  clip = 0;
			  for (i=0;i<12;i++)
			  {
				II_buffer_samplemc(&bs,(*sample),bit_alloc,&fr_ps,&m);
				II_dequantize_samplemc((*sample),bit_alloc,*fraction,&fr_ps, &m, &i);
				II_denormalize_samplemc(*fraction,scale_index,&fr_ps,i>>2, &m, &i);

				if(topSb>0)        /* debug : clear channels to 0 */
				   for(j=topSb; j<fr_ps.sblimit; ++j)
					  for(k= l; k < m; ++k)
						 (*fraction)[k][j][0][i] =
						 (*fraction)[k][j][1][i] =
						 (*fraction)[k][j][2][i] = 0;

			   }

/*********************************************************************/
/* JMZ 09/03/1995 Multilingual */

if (info.no_of_multi_lingual_ch>0) 
	{
		  fr_ps.jsbound = 27;
		  l = 5;
		  m = info.no_of_multi_lingual_ch;

		  II_decode_bitalloc_test(&bs, bit_alloc_test, &fr_ps, &l, &m);
		  II_decode_scale_test(&bs, scfsi_test, bit_alloc_test, scale_index_test, &fr_ps, &l, &m);


			  clip = 0;
			  for (i=0;i<12;i++)
			  {
				II_buffer_sample_test(&bs, (*sample_test), bit_alloc_test, &fr_ps,&m);
				
				II_dequantize_sample_test((*sample_test), bit_alloc_test, *fraction_test, &fr_ps, &m, &i);

				II_denormalize_sample_test(*fraction_test, scale_index_test, &fr_ps,i>>2, &m, &i);

				if(topSb>0)        /* debug : clear channels to 0 */
				   for(j=topSb; j<fr_ps.sblimit; ++j)
					  for(k= l; k < m; ++k)
						 (*fraction)[k][j][0][i] =
						 (*fraction)[k][j][1][i] =
						 (*fraction)[k][j][2][i] = 0;

			   }
	}

/* JMZ 09/03/1995 Multilingual */
/*********************************************************************/

			 /*if(fr_ps.header->mc_prediction_on)*/   /* R.S. */
			
			 /* prediction & dematricing */
			 if(crc_error_count == 0)
			   dematricing(*fraction, &fr_ps, *pred_buf);

			   for(jj=0;jj<12;jj++)
			      for(k=0; k<5; k++)
				  for(j =0; j <3; j++)
				     for(ii=0; ii< SBLIMIT; ii++)
				(*fraction_help)[jj][k][j][ii] = (*fraction)[k][ii][j][jj];

			for (i=0;i<12;i++)
			{			  
			  for (j=0;j<3;j++) 
			    for (k=0; k<5; k++)
				clip += SubBandSynthesis(&((*fraction_help)[i][k][j][0]), k,
							 &((*pcm_sample)[k][j][0]));

				out_fifo(*pcm_sample, 3, &fr_ps, done, musicout,
						 &sample_frames);
			}
			if(clip > 0) printf("%d samples clipped\n", clip);
			
/***************************************************************/
/* 10/03/1995 JMZ Multilingual */
if(info.no_of_multi_lingual_ch>0) /*15/03/1995 TEST*/
	{
			   dematricing_test(*fraction_test, &fr_ps, *pred_buf);
			   
			   for(jj=0;jj<12;jj++)
			      for(k=0; k<info.no_of_multi_lingual_ch; k++)
				  for(j =0; j <3; j++)
				     for(ii=0; ii< SBLIMIT; ii++)
				(*fraction_help_test)[jj][k][j][ii] = (*fraction_test)[k][ii][j][jj];

			for (i=0;i<12;i++)
			{			  
			  for (j=0;j<3;j++) 
			    for (k=0; k<info.no_of_multi_lingual_ch; k++)
				clip += SubBandSynthesis_test(&((*fraction_help_test)[i][k][j][0]), k,
							 &((*pcm_sample_test)[k][j][0]));

				out_fifo_test(*pcm_sample_test, 3, &fr_ps, done, musicout_ml, &sample_frames_test);
			}
		}
/* 10/03/1995 JMZ Multilingual */
/**************************************************************/
			break;

		  }/*end of layer 2*/

	   }/*end of switch layer - loop*/

if( print_out == 1)
{
	if(frameNum == 1) 
	{
		fp4 = fopen("INFODEC", "w+");
		fp2 = fopen("BALDEC", "w+");
		fp3 = fopen("SCFSIDEC", "w+");
		fp1 = fopen("SCFDEC", "w+");
	}
/*********************Ausgabe***************************************************/
fprintf(fp1, "******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp2, "******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp3, "******************** FRAME %d *****************************\n", frameNum-1);
fprintf(fp4, "******************** FRAME %d *****************************\n", frameNum-1);

fprintf(fp4, "version = %d\n", info.version);
fprintf(fp4, "lay = %d\n", info.lay);
fprintf(fp4, "error_protection = %d\n", info.error_protection);
fprintf(fp4, "bitrate_index = %d\n", info.bitrate_index);
fprintf(fp4, "bitrate_index1 = %d\n", info.bitrate_index1);
fprintf(fp4, "bitrate_index2 = %d\n", info.bitrate_index2);
fprintf(fp4, "sampling_frequency = %d\n", info.sampling_frequency);
fprintf(fp4, "padding = %d\n", info.padding);
fprintf(fp4, "extension = %d\n", info.extension);
fprintf(fp4, "mode = %d\n", info.mode);
fprintf(fp4, "mode_ext = %d\n", info.mode_ext);
fprintf(fp4, "copyright = %d\n", info.copyright);
fprintf(fp4, "original = %d\n", info.original);
fprintf(fp4, "emphasis = %d\n", info.emphasis);
fprintf(fp4, "center = %d\n", info.center);
fprintf(fp4, "surround = %d\n", info.surround);
fprintf(fp4, "dematrix_procedure = %d\n", info.dematrix_procedure);
fprintf(fp4, "lfe = %d\n", info.lfe);
fprintf(fp4, "no_of_multi_lingual_ch = %d\n", info.no_of_multi_lingual_ch);
fprintf(fp4, "multi_lingual_fs = %d\n", info.multi_lingual_fs);
fprintf(fp4, "multi_lingual_layer = %d\n", info.multi_lingual_layer);
fprintf(fp4, "mc_prediction_on = %d\n", info.mc_prediction_on);
if(info.mc_prediction_on == 1)
   for(hu = 0; hu < 8; ++ hu)
   {
	fprintf(fp4, "mc_prediction[%d] = %d ", hu, info.mc_prediction[hu]);
	for(ho = 0; ho < 4; ho++)
	{
		fprintf(fp4, "mc_predsi[%d][%d] = %d  ", hu,ho, info.mc_predsi[hu][ho]);
		fprintf(fp4, "mc_delay[%d][%d] = %d  ", hu,ho, info.mc_delay_comp[hu][ho]);
		fprintf(fp4, " \n");
		for(hi = 0;hi <3; hi++)
		fprintf(fp4, "pred_coeff[%d][%d][%d] = %d ",hu,ho,hi,info.mc_pred_coeff[hu][ho][hi]);
		fprintf(fp4, " \n");
	}
   }

fprintf(fp4, "tc_sbgr_select = %d\n", info.tc_sbgr_select);
if(info.tc_sbgr_select == 1)
  fprintf(fp4, "tc_allocation = %d\n", info.tc_allocation);
else
	{
		for(ho = 0; ho < 12; ho ++)
	{
		if(info.mc_prediction[ho] == 0)
		fprintf(fp4, "tc_alloc[%d] = %d\n", ho, info.tc_alloc[ho]);
		else{
		for(hu = 0; hu < 4; hu++)
				fprintf(fp4, "predsi[%d][%d] = %d\n", ho, hu, info.mc_predsi[ho][hu]);
		}
	}
	fprintf(fp4, "\n");
	}

for(hu = 0; hu < SBLIMIT; ++hu)
{
	fprintf(fp2, "\n");
	fprintf(fp3, "\n");

	for(hi = 0; hi < 5; hi ++)
	{
	fprintf(fp1, "\n");
	fprintf(fp2, "\n");
	fprintf(fp3, "\n");
	fprintf(fp2, "BAL[%d][%d] = %d\t", hi, hu, bit_alloc[hi][hu]);
	fprintf(fp3, "SCFSI[%d][%d] = %d\t", hi, hu, scfsi[hi][hu]);

	for( ho = 0; ho < 3; ho ++)
	{
	   fprintf(fp1, "SCF[%d][%d][%d] = %d\t", hi, ho, hu, scale_index[hi][ho][hu]);
	}
	}
	fprintf(fp1, "\n");
}
/*******************************************************************************/

} /* endif of print_out == 1 */

	}/*end of while(!endof(bs)) - loop */

	if (need_aiff) {
	   pcm_aiff_data.numChannels       = stereo + mc_channel;
	   pcm_aiff_data.numSampleFrames   = sample_frames;
	   pcm_aiff_data.sampleSize        = 16;
	   pcm_aiff_data.sampleRate        = s_freq[info.sampling_frequency]*1000;
	   strcpy(pcm_aiff_data.sampleType, IFF_ID_SSND);
	   pcm_aiff_data.blkAlgn.offset    = 0;
	   pcm_aiff_data.blkAlgn.blockSize = 0;

	   if (aiff_write_headers(musicout, &pcm_aiff_data) == -1) {
		  printf("Could not write AIFF headers to \"%s\"\n",
				 decoded_file_name);
		  exit(2);
	   }
	 }

	printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",
		   (FLOAT) gotBits / (frameNum * bitsPerSlot),
		   (FLOAT) gotBits / (frameNum * samplesPerFrame),
		   (FLOAT) gotBits / (frameNum * samplesPerFrame) *
		   s_freq[info.sampling_frequency]);

	close_bit_stream_r(&bs);
#ifdef CONCAT
close_bit_stream_w_concat(&bs_concat);	/* 23/03/1995 JMZ Concat */
#endif CONCAT
	if (info.ext_bit_stream_present)
	{
	     close_bit_stream_r(&bs_ext);

	}
	fclose(musicout);


	printf("Decoding of \"%s\" with %lu frames is finished\n", encoded_file_name, frameNum);
	printf("The decoded PCM output file name is \"%s\"\n", decoded_file_name);
	if (need_aiff)
	   printf("\"%s\" has been written with AIFF header information\n",
			  decoded_file_name);
	if(total_error_countmc != 0)
	printf("There were %d frames,  which were not in multichannel!!\n", total_error_countmc);

if(print_out ==1)
{
	fclose(fp1);
	fclose(fp2);
	fclose(fp3);
	fclose(fp4);
}
return(1);
}


void usage(void)  /* print syntax & exit */
{
   fprintf(stderr,
      "usage: %s                         queries for all arguments, or\n",
	   programName);
   fprintf(stderr,
      "       %s [-a] [-i] inputBS [outPCM]\n", programName);
   fprintf(stderr,"where\n");
   fprintf(stderr," -a       write a RAW data sound file  (default: write an AIFF sound file)\n");
                     /* default: write an AIFF sound file  */
   fprintf(stderr," -i       write encoded bitstream-information in a file\n"); 
   		     /* default: don't write encoded information */
   fprintf(stderr," inputBS  input bit stream of encoded audio\n");
   fprintf(stderr," outPCM   output PCM sound file (dflt inName+%s)\n",
           DFLT_OPEXT);
   exit(1);
}
