/**********************************************************************
 * Copyright (c) 1995 MPEG/audio software simulation group
 * All Rights Reserved
 * $Id: musicin.c,v 1.4 1995/04/06 04:29:39 rowlands Exp $
 *
 * MPEG/audio coding/decoding software, work in progress
 *   NOT for public distribution until verified and approved by the
 *   MPEG/audio committee.
 *
 * $Log: musicin.c,v $
 * Revision 1.4  1995/04/06  04:29:39  rowlands
 * Added header and RCS info to initial revision.
 *
 **********************************************************************/

/**********************************************************************
 * VERSION 2.5                                                        *
 *   changes made since last update:                                  *
 *   date   programmers         comment                               *
 * 3/01/91  Douglas Wong,       start of version 1.1 records          *
 *          Davis Pan                                                 *
 * 3/06/91  Douglas Wong,       rename: setup.h to endef.h            *
 *                              removed extraneous variables          *
 * 3/21/91  J.Georges Fritsch   introduction of the bit-stream        *
 *                              package. This package allows you      *
 *                              to generate the bit-stream in a       *
 *                              binary or ascii format                *
 * 3/31/91  Bill Aspromonte     replaced the read of the SB matrix    *
 *                              by an "code generated" one            *
 * 5/10/91  W. Joseph Carter    Ported to Macintosh and Unix.         *
 *                              Incorporated Jean-Georges Fritsch's   *
 *                              "bitstream.c" package.                *
 *                              Modified to strictly adhere to        *
 *                              encoded bitstream specs, including    *
 *                              "Berlin changes".                     *
 *                              Modified user interface dialog & code *
 *                              to accept any input & output          *
 *                              filenames desired.  Also added        *
 *                              de-emphasis prompt and final bail-out *
 *                              opportunity before encoding.          *
 *                              Added AIFF PCM sound file reading     *
 *                              capability.                           *
 *                              Modified PCM sound file handling to   *
 *                              process all incoming samples and fill *
 *                              out last encoded frame with zeros     *
 *                              (silence) if needed.                  *
 *                              Located and fixed numerous software   *
 *                              bugs and table data errors.           *
 * 27jun91  dpwe (Aware Inc)    Used new frame_params struct.         *
 *                              Clear all automatic arrays.           *
 *                              Changed some variable names,          *
 *                              simplified some code.                 *
 *                              Track number of bits actually sent.   *
 *                              Fixed padding slot, stereo bitrate    *
 *                              Added joint-stereo : scales L+R.      *
 * 6/12/91  Earle Jennings      added fix for MS_DOS in obtain_param  *
 * 6/13/91  Earle Jennings      added stack length adjustment before  *
 *                              main for MS_DOS                       *
 * 7/10/91  Earle Jennings      conversion of all float to FLOAT      *
 *                              port to MsDos from MacIntosh completed*
 * 8/ 8/91  Jens Spille         Change for MS-C6.00                   *
 * 8/22/91  Jens Spille         new obtain_parameters()               *
 *10/ 1/91  S.I. Sudharsanan,   Ported to IBM AIX platform.           *
 *          Don H. Lee,                                               *
 *          Peter W. Farrett                                          *
 *10/ 3/91  Don H. Lee          implemented CRC-16 error protection   *
 *                              newly introduced functions are        *
 *                              I_CRC_calc, II_CRC_calc and encode_CRC*
 *                              Additions and revisions are marked    *
 *                              with "dhl" for clarity                *
 *11/11/91 Katherine Wang       Documentation of code.                *
 *                                (variables in documentation are     *
 *                                surround by the # symbol, and an '*'*
 *                                denotes layer I or II versions)     *
 * 2/11/92  W. Joseph Carter    Ported new code to Macintosh.  Most   *
 *                              important fixes involved changing     *
 *                              16-bit ints to long or unsigned in    *
 *                              bit alloc routines for quant of 65535 *
 *                              and passing proper function args.     *
 *                              Removed "Other Joint Stereo" option   *
 *                              and made bitrate be total channel     *
 *                              bitrate, irrespective of the mode.    *
 *                              Fixed many small bugs & reorganized.  *
 * 2/25/92  Masahiro Iwadare    made code cleaner and more consistent *
 *10 jul 92 Susanne Ritscher    Bug fix in main, scale factor calc.   *
 * 5 aug 92 Soren H. Nielsen    Printout of bit allocation.           *
 *19 aug 92 Soren H. Nielsen	Changed MS-DOS file name extensions.  *
 * 2 dec 92 Susanne Ritscher	Start of changes to multi-channel with*
 *                                                  several options   *										 *
 **********************************************************************
 *                                                                    *
 *                                                                    *
 *  MPEG/audio Phase 2 coding/decoding multichannel                   *
 *                                                                    *
 *                                                                    *
 *  7/27/93        Susanne Ritscher,  IRT Munich                      *
 *                                                                    *
 *	                                                              *
 *  8/13/93        implemented channel-switching by changing          *
 *                 a lot in encode.c                                  *
 *                                                                    *
 *  8/27/93        Susanne Ritscher, IRT Munich                       *
 *                 Channel-Switching is working                       *
 *  9/1/93         Susanne Ritscher,  IRT Munich                      *
 *                 all channels normalized                            *
 *  9/20/93        channel-switching is only performed at a           *
 *                 certain limit of TC_ALLOC dB, which is included    *
 *                 in encoder.h                                       *
 *  1/04/94        try get all the rubbish out!                       *
 *                                                                    *
 *                                                                    *
 *  Version 1.0 Shareware                                             *
 *                                                                    *
 *  07/12/94       Susanne Ritscher,  IRT Munich                      *
 *                 Tel: +49 89 32399 458                              *
 *                 Fax: +49 89 32399 415                              *
 *                                                                    *
 *  Version 1.1 Shareware                                             *
 *                                                                    *
 *  02/23/95	   Susanne Ritscher,  IRT Munich                      *
 *                 corrected some bugs                                *
 *                 extension bitstream is working                     *
 *                                                                    *
 **********************************************************************/
#ifdef MS_DOS
#include <dos.h>
#endif
#include "common.h"
#include "encoder.h"
#include <math.h>

/* Global variable definitions for "musicin.c" */

FILE               *musicin;
FILE               *musicin_ml;	/* 08/03/1995 JMZ Multilingual */
Bit_stream_struc   bs;
Bit_stream_struc   bs_ext;
Bit_stream_struc   bs_mpg;
char               *programName;
char multilingual_file_name[MAX_NAME_SIZE];	/* 08/03/1995 JMZ Multilingual */

/* Implementations */

/************************************************************************
/*
/* obtain_parameters
/*
/* PURPOSE:  Prompts for and reads user input for encoding parameters
/*
/* SEMANTICS:  The parameters read are:
/* - input and output filenames
/* - sampling frequency (if AIFF file, will read from the AIFF file header)
/* - layer number
/* - mode (stereo, joint stereo, dual channel or mono)
/* - psychoacoustic model (I or II)
/* - total bitrate, irrespective of the mode
/* - de-emphasis, error protection, copyright and original or copy flags
/*
/************************************************************************/

void
obtain_parameters(frame_params *fr_ps, int *psy, long unsigned int *num_samples, long unsigned int *num_samples_ml, char *original_file_name, char *encoded_file_name, IFF_AIFF *pcm_aiff_data, IFF_AIFF *pcm_aiff_data_ml, int *aiff, int *byte_per_sample, int *cha_sw, char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg)
                       
                     
                             
                                 	/* 08/03/1995 JMZ Multilingual */
    		                                  
    		                                 
         	               
         	                   	/* 08/03/1995 JMZ Multilingual */
   		      
   		                 
                        
    		                                     
    		                                     
                          
{
	 int j;
	 long int i;
	 int tot_channels =0;		/* 21/03/1995 JMZ Multimode */ 
	 char configuration[50];	/* 21/03/1995 JMZ Multimode */
	 char t[50];

	 layer *info = fr_ps->header;

	 *aiff = 0;	 /* flag for AIFF-Soundfile*/
	 *cha_sw = 0;
 
    do  {
       printf("Enter PCM input file name <required>: ");
       gets(original_file_name);
       if (original_file_name[0] == NULL_CHAR)
       printf("PCM input file name is required.\n");
    } while (original_file_name[0] == NULL_CHAR);
    printf(">>> PCM input file name is: %s\n", original_file_name);
 
    if ((musicin = fopen(original_file_name, "rb")) == NULL) {
       printf("Could not find \"%s\".\n", original_file_name);
       exit(0);
	 }
/***************************************************************************/
/* 08/03/1995 Multi lingual extension JMZ                                  */

printf("Do you have multi lingual channels? (Y)es, (<N>)o: ");
gets(multilingual_file_name);
if ((*multilingual_file_name=='Y')||(multilingual_file_name[0]=='y'))
{
	printf("Enter multilingual input file name <%s.ml>: ",original_file_name);
	gets(multilingual_file_name);
	if (multilingual_file_name[0] == NULL_CHAR)
	{
		printf("Null char\n");
		strcat(strcpy(multilingual_file_name, original_file_name), ".ml");
	}
	if ((musicin_ml = fopen(multilingual_file_name, "rb")) == NULL) 
	{
		printf("Could not find \"%s\".\n", multilingual_file_name);
		exit(0);
	}
/*remplir fr_ps il y a au moins un multilingual*/
	if (aiff_read_headers(musicin_ml, pcm_aiff_data_ml, byte_per_sample) == 0) 
	{
		printf(">>> Using Audio IFF multilingual file headers\n");
		info->multiling_ch = pcm_aiff_data_ml->numChannels;
		printf(">>> Using %d multilingual channels\n",info->multiling_ch);
       *num_samples_ml = pcm_aiff_data_ml->numChannels *
                      pcm_aiff_data_ml->numSampleFrames;
		printf(">>>JMZ num_samples_ml= %d \n",*num_samples_ml);
	}
	else     /* Not using Audio IFF sound file headers. */
	{
		printf("no multichannel coding!!\n exit");
		exit(0);
	}
}

/* 08/03/1995 Multi lingual extension JMZ                                  */
/***************************************************************************/
	
    printf("Enter MPEG encoded output file name <%s%s>: ",
		original_file_name, DFLT_EXT);

    gets(encoded_file_name);
    if (encoded_file_name[0] == NULL_CHAR)

      strcat(strcpy(encoded_file_name, original_file_name), DFLT_EXT);

    printf(">>> MPEG encoded output file name is: %s\n", encoded_file_name);
 
    open_bit_stream_w(&bs, encoded_file_name, BUFFER_SIZE);
 
	 if (aiff_read_headers(musicin, pcm_aiff_data, byte_per_sample) == 0) {

		 printf(">>> Using Audio IFF sound file headers\n");

/**********************************************************/
/* 21/03/1995 JMZ Multimode */
		 tot_channels = pcm_aiff_data->numChannels;
		printf(">>> Using %d audio channels\n",tot_channels);

		 *aiff = 1;
		 tot_channels = pcm_aiff_data->numChannels;
		 if(tot_channels == 5) 
		 	{
		 	fr_ps->stereomc =3;
    		printf("Which configuration do you want to use?\n");
    		printf("Available: 3/2 (<1>), 3/0 + 2/0 (2): ");
    		gets(configuration);
    		switch(*configuration)
    			{
       			case '1': 
       				info->center = 1; 
       				info->surround = 2; 
       				break;
       			case '2': 
      				info->center = 1; 
       				info->surround = 3; 
       				break;
       			default:  
      				info->center = 1; 
       				info->surround = 2; 
       				printf(">>> Using default Layer 2\n"); 
       				break;
	 			}
		 	}
		 if(tot_channels == 4) 
		 	{
		 	fr_ps->stereomc =2;
    		printf("Which configuration do you want to use?\n");
    		printf("Available: 3/1 (<1>), 2/2 (2), 2/0 + 2/0 (3): ");
    		gets(configuration);
    		switch(*configuration)
    			{
       			case '1': 
       				info->center = 1; 
       				info->surround = 1; 
       				break;
       			case '2': 
      				info->center = 0; 
       				info->surround = 2; 
       				break;
       			case '3': 
      				info->center = 0; 
       				info->surround = 3; 
       				break;
       			default:  
      				info->center = 1; 
       				info->surround = 1; 
       				printf(">>> Using default Layer 2\n"); 
       				break;
	 			}
		 	}
		 if(tot_channels == 3) 
		 	{
		 	fr_ps->stereomc =1;
    		printf("Which configuration do you want to use?\n");
    		printf("Available: 3/0 (<1>), 2/1 (2): ");
    		gets(configuration);
    		switch(*configuration)
    			{
       			case '1': 
       				info->center = 1; 
       				info->surround = 0; 
       				printf(">>> Using Layer %s\n",t); 
       				break;
       			case '2': 
      				info->center = 0; 
       				info->surround = 1; 
       				printf(">>> Using Layer %s\n",t); 
       				break;
       			default:  
      				info->center = 1; 
       				info->surround = 0; 
       				printf(">>> Using default Layer 2\n"); 
       				break;
	 			}
		 	}
		 if(tot_channels == 2) 
		 	{
		 	fr_ps->stereomc =0;
		 	}
		 if(tot_channels == 1) 
		 	{
		 	fr_ps->stereomc =0;
		 	}
		 aiff_check(original_file_name, pcm_aiff_data);
/* 21/03/1995 JMZ Multimode */
/**********************************************************/


       info->sampling_frequency = SmpFrqIndex((long)pcm_aiff_data->sampleRate);
       printf(">>> %.f Hz sampling frequency selected\n",
				  pcm_aiff_data->sampleRate);

       /* Determine number of samples in sound file */
       *num_samples = pcm_aiff_data->numChannels *
                      pcm_aiff_data->numSampleFrames;
    }
    else {    /* Not using Audio IFF sound file headers. */
		 printf("no multichannel coding!!\n");
		fr_ps->stereomc = 0;
       printf("What is the sampling frequency? <48000>[Hz]: ");
       gets(t);
       i = atol(t);
       switch (i) {
          case 48000 : info->sampling_frequency = 1;
              printf(">>> %ld Hz sampling freq selected\n", i);
              break;
          case 44100 : info->sampling_frequency = 0;
              printf(">>> %ld Hz sampling freq selected\n", i);
              break;
          case 32000 : info->sampling_frequency = 2;
              printf(">>> %ld Hz sampling freq selected\n", i);
              break;
          default:    info->sampling_frequency = 1;
              printf(">>> Default 48 kHz samp freq selected\n");
       }
 
       if (fseek(musicin, 0, SEEK_SET) != 0) {
          printf("Could not seek to PCM sound data in \"%s\".\n",
                  original_file_name);
          exit(0);
       }
 
       /* Declare sound file to have "infinite" number of samples. */
       *num_samples = MAX_U_32_NUM;

    }

    printf("Which layer do you want to use?\n");
    printf("Available: Layer (1), Layer (<2>): ");
    gets(t);
    switch(*t){
       case '1': info->lay = 1; printf(">>> Using Layer %s\n",t); break;
       case '2': info->lay = 2; printf(">>> Using Layer %s\n",t); break;
       default:  info->lay = 2; printf(">>> Using default Layer 2\n"); break;
	 }

	if( *aiff == 1)
	{
	 printf("Which mode do you want for the two front channels?\n");
         printf("Available: (<s>)tereo, (j)oint stereo, ");
	 printf("(d)ual channel, s(i)ngle Channel, n<o>ne: ");
          gets(t);
           switch(*t){
             case 's':
             case 'S':
	        info->mode = MPG_MD_STEREO; info->mode_ext = 0;
		 printf(">>> Using mode %s\n",t);
	          break;
	     case 'j':
             case 'J':
	        info->mode = MPG_MD_JOINT_STEREO;
	          printf(">>> Using mode %s\n",t);
	          break;
             case 'd':
             case 'D':
	          info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext = 0;
	          printf(">>> Using mode %s\n",t);
	          break;
             case 'i':
             case 'I':
	          info->mode = MPG_MD_MONO; info->mode_ext = 0;
	          printf(">>> Using mode %s\n",t);
	       	  break;
             case 'o':
             case 'O':
	          info->mode = MPG_MD_NONE; info->mode_ext = 0;
	          printf(">>> Using mode %s\n",t);
	       	  break;
             default:
	          info->mode = MPG_MD_STEREO; info->mode_ext = 0;
	          printf(">>> Using default stereo mode\n");
	          break;
           }
	}
	else    /* not aiff */
	{
	    printf("Available: (<s>)tereo, (j)oint stereo, ");
	    printf("(d)ual channel, s(i)ngle Channel: ");
	        gets(t);
	        switch(*t){
	           case 's':
	           case 'S':
	              info->mode = MPG_MD_STEREO; info->mode_ext = 0;
	              printf(">>> Using mode %s\n",t);
	              break;
	           case 'j':
	           case 'J':
	              info->mode = MPG_MD_JOINT_STEREO;
	              printf(">>> Using mode %s\n",t);
	              break;
	           case 'd':
	           case 'D':
	              info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext = 0;
	              printf(">>> Using mode %s\n",t);
	              break;
	           case 'i':
	           case 'I':
	              info->mode = MPG_MD_MONO; info->mode_ext = 0;
	              printf(">>> Using mode %s\n",t);
		      break;
	           default:
	              info->mode = MPG_MD_STEREO; info->mode_ext = 0;
	              printf(">>> Using default stereo mode\n");
	              break;
                }
	}


		 *psy = 1;

	 printf("What is the total bitrate? <%u>[kbps]: ", DFLT_BRT);
		gets(t);
		i = atol(t);
		if (i == 0) i = -10;
		j=0;
		 while (j<=15) 
		 {
		  if (bitrate[info->lay-1][j] == (int) i) break;
		  j++;
		 }
		 if (j==16) 
		 {
		  if(i <= 384)
		  {
	            printf(">>> Using default %u kbps\n", DFLT_BRT);
		    for (j=0;j<15;j++)
	            if (bitrate[info->lay-1][j] == DFLT_BRT) 
		    {
	              info->bitrate_index = j;
	              break;
	            }
		  }
		  else
		  {
		       info->ext_bit_stream_present = 1;
		       info->n_ad_bytes = 1; /* for DTB!!! 06/14/94 */
		       for (j=0;j<15;j++)
		       if (bitrate[info->lay-1][j] == DFLT_BRT) 
		       {
			   info->bitrate_index = j;
			   break;
		       }
		       *bit_rate = i;
		       info->ext_length = ((i - DFLT_BRT) * 24) / 8;
		  }			   
		 }
		 else
		 {
		  info->bitrate_index = j;
		  printf(">>> Bitrate = %d kbps\n", bitrate[info->lay-1][j]);
		 }


 
    printf("What type of de-emphasis should the decoder use?\n");
    printf("Available: (<n>)one, (5)0/15 microseconds, (c)citt j.17: ");
    gets(t);
    if (*t != 'n' && *t != '5' && *t != 'c') {
       printf(">>> Using default no de-emphasis\n");
       info->emphasis = 0;
    }
    else {
       if (*t == 'n')      info->emphasis = 0;
       else if (*t == '5') info->emphasis = 1;
       else if (*t == 'c') info->emphasis = 3;
       printf(">>> Using de-emphasis %s\n",t);
    }
 
/*  Start 2. Part changes for CD Ver 3.2; jsp; 22-Aug-1991 */
 
    printf("Do you want to set the private bit? (y/<n>): ");
    gets(t);
    if (*t == 'y' || *t == 'Y') info->extension = 1;
    else                        info->extension = 0;
    if(info->extension) printf(">>> Private bit set\n");
    else                printf(">>> Private bit not set\n");
 
/*  End changes for CD Ver 3.2; jsp; 22-Aug-1991 */
	
	 printf("Do you want error protection? (y/<n>): ");
	 gets(t);
	 if (*t == 'y' || *t == 'Y') info->error_protection = TRUE;
         else                        info->error_protection = FALSE;
	 if(info->error_protection) printf(">>> Error protection used\n");
	 else printf(">>> Error protection not used\n");
	

    printf("Is the material copyrighted? (y/<n>): ");
    gets(t);
    if (*t == 'y' || *t == 'Y') info->copyright = 1;
    else                        info->copyright = 0;
    if(info->copyright) printf(">>> Copyrighted material\n");
    else                printf(">>> Material not copyrighted\n");
 
    printf("Is this the original? (y/<n>): ");
    gets(t);
    if (*t == 'y' || *t == 'Y') info->original = 1;
    else                        info->original = 0;
    if(info->original) printf(">>> Original material\n");
    else	       printf(">>> Material not original\n");
    
    /* Option for multichannel for matricing, 7/12/93,SR*/
    if(*aiff == 1)
    {
        printf("which kind of matrix do you want(<(-3, -3) = 0>;(-xx, -3) = 1;");
	printf(" (-oo, -3) = 2; (-oo, -oo) = 3)  ");
	gets(t);
	if(strcmp(t,"") == 0) info->matrix = 0;
	else          info->matrix = atoi(t);
	printf("The matrix %d is chosen\n", info->matrix);


	 printf("Do you want to have Channel-switching based on SCF?(y/<n>)");
	 gets(t);
	 if(*t == 'y')  
	 {
	  *cha_sw = 1;
	  printf("Channel-switching on SCF is used!\n");
	 } 
	 else
	 {
	  *cha_sw = 0;
           printf("Channel-switching is not used\n");	 
	 }
	 
    }

 
    printf("Do you wish to exit (last chance before encoding)? (y/<n>): ");
    gets(t);
    if (*t == 'y' || *t == 'Y') exit(0);
}   

/************************************************************************
/*
/* parse_args
/*
/* PURPOSE:  Sets encoding parameters to the specifications of the
/* command line.  Default settings are used for parameters
/* not specified in the command line.
/*
/* SEMANTICS:  The command line is parsed according to the following
/* syntax:
/*
/* -l  is followed by the layer number
/* -m  is followed by the mode of the two front channels
/* -r  is followed by the sampling rate
/* -b  is followed by the total bitrate, irrespective of the mode
/* -d  is followed by the emphasis flag
/* -c  is followed by the copyright/no_copyright flag
/* -o  is followed by the original/not_original flag
/* -e  is followed by the error_protection on/off flag
/* -g  is followed by the matrix
/* -k  is followed by the channel-switching flag based on SCF
/*
/* If the input file is in AIFF format, the sampling frequency is read
/* from the AIFF header.
/*
/* The input and output filenames are read into #inpath# and #outpath#.
/*
/************************************************************************/
 
void
parse_args(int argc, char **argv, frame_params *fr_ps, int *psy, long unsigned int *num_samples, char *inPath, char *outPath, int *aiff, int *byte_per_sample, int *cha_sw, IFF_AIFF *pcm_aiff_data, char *encoded_file_name_ext, int *bit_rate, char *encoded_file_name_mpg)
{
   FLOAT srate;
	int	brate;
layer *info = fr_ps->header;
   int   err = 0, i = 0;
   
  *cha_sw = 0;
  fr_ps->mnr_min = 0.0;
  info->matrix = 0;
  *aiff = 0;
 
   /* preset defaults */
   inPath[0] = '\0';   outPath[0] = '\0';
   info->lay = DFLT_LAY;
   switch(DFLT_MOD) {
      case 'r': info->mode = MPG_MD_STEREO; info->mode_ext = 0; break;
      case 'd': info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; break;
      case 'j': info->mode = MPG_MD_JOINT_STEREO; break;
      case 'm': info->mode = MPG_MD_MONO; info->mode_ext = 0; break;
      default:
         fprintf(stderr, "%s: Bad mode dflt %c\n", programName, DFLT_MOD);
         abort();
   }
   *psy = DFLT_PSY;
   if((info->sampling_frequency = SmpFrqIndex((long)(1000*DFLT_SFQ))) < 0) {
      fprintf(stderr, "%s: bad sfrq default %.2f\n", programName, DFLT_SFQ);
      abort();
   }
   info->bitrate_index = DFLT_BRT;
   if((info->bitrate_index = BitrateIndex(info->lay, DFLT_BRT)) < 0) {
      fprintf(stderr, "%s: bad default bitrate %u\n", programName, DFLT_BRT);
      abort();
   }
   switch(DFLT_EMP) {
      case 'n': info->emphasis = 0; break;
      case '5': info->emphasis = 1; break;
      case 'c': info->emphasis = 3; break;
      default: 
         fprintf(stderr, "%s: Bad emph dflt %c\n", programName, DFLT_EMP);
         abort();
   }
   info->copyright = 0; info->original = 0; info->error_protection = FALSE;
 
   /* process args */
   while(++i<argc && err == 0) {
		char c, *token, *arg, *nextArg;
      int  argUsed;
 
      token = argv[i];
      if(*token++ == '-') {
         if(i+1 < argc) nextArg = argv[i+1];
         else           nextArg = "";
         argUsed = 0;
         while(c = *token++) {
            if(*token /* NumericQ(token) */) arg = token;
            else                             arg = nextArg;
            switch(c) {
               case 'l':        info->lay = atoi(arg); argUsed = 1;
                  if(info->lay<1 || info->lay>2) {
                     fprintf(stderr,"%s: -l layer must be 1 or 2, not %s\n",
                          programName, arg);
                     err = 1;
                  }
                  break;
					case 'm':				  argUsed = 1;
                  if (*arg == 's')
                    { info->mode = MPG_MD_STEREO; info->mode_ext = 0; }
                  else if (*arg == 'd')
                    { info->mode = MPG_MD_DUAL_CHANNEL; info->mode_ext=0; }
                  else if (*arg == 'j')
                    { info->mode = MPG_MD_JOINT_STEREO; }
                  else if (*arg == 'm')
			  { info->mode = MPG_MD_MONO; info->mode_ext = 0; }
	     	  else if (*arg == 'n')
			  { info->mode = MPG_MD_NONE; info->mode_ext = 0; }
                  else 
		  {
                    fprintf(stderr,"%s: -m mode must be s/d/j/m not %s\n",
                            programName, arg);
                    err = 1;
		  }
						break;
		  case 'r':		  
			    srate = atof(arg); argUsed = 1;
	                      if( (info->sampling_frequency =
	                       SmpFrqIndex((long)(1000*srate))) < 0)
	                         err = 1;
			          break;
	          case 'b': 
		              brate = atoi(arg); argUsed = 1;
			      if(brate > 384)
			      {
				 info->ext_bit_stream_present = 1;
				 info->n_ad_bytes = 1; /* for DTB!!! 06/14/94 */
				*bit_rate = brate;
				brate = DFLT_BRT;
				info->ext_length = ((*bit_rate - DFLT_BRT) * 24) / 8;
				}			   
				break;
		  case 'd':  
		             argUsed = 1;
                    if (*arg == 'n')                    info->emphasis = 0;
                    else if (*arg == '5')               info->emphasis = 1;
                    else if (*arg == 'c')               info->emphasis = 3;
                    else 
		    {
                       fprintf(stderr,"%s: -d emp must be n/5/c not %s\n",
                             programName, arg);
                        err = 1;
                     }
                     break;
                   case 'c':       info->copyright = 1; break;
                   case 'o':       info->original  = 1; break;
                   case 'e':       info->error_protection = TRUE; break;
		   case 'g':       info->matrix = atoi(arg); 
		                   argUsed = 1;
				   break;
		   case 'k':       *cha_sw = 1; break;
				   
                default:        fprintf(stderr,"%s: unrec option %c\n",
                                        programName, c);
                                err = 1; break;
            }
	    
	    
            if(argUsed) {
               if(arg == token)    token = "";   /* no more from token */
               else                ++i;          /* skip arg we used */
               arg = ""; argUsed = 0;
            }
         }
      }
      else {
         if(inPath[0] == '\0')       strcpy(inPath, argv[i]);
         else if(outPath[0] == '\0') strcpy(outPath, argv[i]);
         else {
            fprintf(stderr,"%s: excess arg %s\n", programName, argv[i]);
            err = 1;
         }
      }
   }
	if( (info->bitrate_index = BitrateIndex(info->lay, brate)) < 0) err=1;
   if(err || inPath[0] == '\0') usage();  /* never returns */
 
   if(outPath[0] == '\0') {
      strcpy(outPath, inPath);
      strcat(outPath, DFLT_EXT);
   }
 
   if ((musicin = fopen(inPath, "rb")) == NULL) {
      printf("Could not find \"%s\".\n", inPath);
      exit(0);
   }
 




   open_bit_stream_w(&bs, outPath, BUFFER_SIZE);

	if (aiff_read_headers(musicin, pcm_aiff_data, byte_per_sample) == 0) {

		 printf(">>> Using Audio IFF sound file headers\n");

		 *aiff = 1;
      printf(">>> Using Audio IFF sound file headers\n");

      aiff_check(inPath, pcm_aiff_data);

      info->sampling_frequency = SmpFrqIndex((long)pcm_aiff_data->sampleRate);
      printf(">>> %.f Hz sampling frequency selected\n",
             pcm_aiff_data->sampleRate);

      /* Determine number of samples in sound file */
#ifndef MS_DOS
      *num_samples = pcm_aiff_data->numChannels *
                     pcm_aiff_data->numSampleFrames;
#else
      *num_samples = (long)(pcm_aiff_data->numChannels) *
                     (long)(pcm_aiff_data->numSampleFrames);
#endif

   }
   else {    /* Not using Audio IFF sound file headers. */
   
	printf(" NO MULTICHANNEL CODING!!\n");
      if (fseek(musicin, 0, SEEK_SET) != 0) {
         printf("Could not seek to PCM sound data in \"%s\".\n", inPath);
         exit(0);
      }
 
      /* Declare sound file to have "infinite" number of samples. */
      *num_samples = MAX_U_32_NUM;

   }

}

/************************************************************************
/*
/* print_config
/*
/* PURPOSE:  Prints the encoding parameters used
/*
/************************************************************************/
 
void
print_config(frame_params *fr_ps, int *psy, long unsigned int *num_samples, char *inPath, char *outPath, int *aiff)
{
 layer *info = fr_ps->header;
 
	printf("Encoding configuration:\n");
	if(*aiff == 1){
		printf("Layer=%s   mode=%s   extn=%d   psy model=%d\n",
		  layer_names[info->lay-1], mode_names[info->mode],
		 info->mode_ext, *psy);
	}
	else{
		printf("Layer=%s   mode=%s   extn=%d    psy model=%d\n",
	          layer_names[info->lay-1], mode_names[info->mode],
		 info->mode_ext, *psy);
	}

	if( info->bitrate_index != 0){
		if( bitrate[info->lay-1][info->bitrate_index] == 1000)
			printf("samp frq=%.1f kHz   total bitrate=dynamic bitrate\n",
			 s_freq[info->sampling_frequency]);
		else
			printf("samp frq=%.1f kHz   total bitrate=%d kbps\n",
	                s_freq[info->sampling_frequency],
			bitrate[info->lay-1][info->bitrate_index]);
	 }


   printf("de-emph=%d   c/right=%d   orig=%d   errprot=%d\n",
          info->emphasis, info->copyright, info->original,
          info->error_protection);
   printf("input file: '%s'   output file: '%s'\n", inPath, outPath);
}
 
/************************************************************************
/*
/* main
/*
/* PURPOSE:  MPEG I Encoder supporting layers 1 and 2, and
/* psychoacoustic models 1 (MUSICAM) and 2 (AT&T),now portated
/* to multichannel (two front channels, one center and three surround
/* channels. There are different possibilities to code the AIFF-signal,
/* like coding only the surround channels or the front channels,
/* different bitrates for front and surropund channels etc.
/* dec1992 sr.
/*
/* SEMANTICS:  One overlapping frame of audio of up to 2 channels are
/* processed at a time in the following order:
/* (associated routines are in parentheses)
/*
/* 1.  Filter sliding window of data to get 32 subband
/* samples per channel.
/* (window_subband,filter_subband)
/*
/* 2.  If joint stereo mode, combine left and right channels
/* for subbands above #jsbound#.
/* (*_combine_LR)
/*
/* 3.  Calculate scalefactors for the frame, and if layer 2,
/* also calculate scalefactor select information.
/* (*_scale_factor_calc)
/*
/* 4.  Calculate psychoacoustic masking levels using selected
/* psychoacoustic model.
/* (*_Psycho_One, psycho_anal)
/*
/* 5.  Perform iterative bit allocation for subbands with low
/* mask_to_noise ratios using masking levels from step 4.
/* (*_main_bit_allocation)
/*
/* 6.  If error protection flag is active, add redundancy for
/* error protection.
/* (*_CRC_calc)
/*
/* 7.  Pack bit allocation, scalefactors, and scalefactor select
/* information (layer 2) onto bitstream.
/* (*_encode_bit_alloc,*_encode_scale,II_transmission_pattern)
/*
/* 8.  Quantize subbands and pack them into bitstream
/* (*_subband_quantization, *_sample_encoding)
/*
/************************************************************************/

#ifdef MS_DOS
extern unsigned _stklen = 16384;
#endif

main(int argc, char **argv)
{
/*typedef double SBS[7][3][12][SBLIMIT];*/
/*    SBS               *sbsample;*/
double sb_sample[14][3][12][SBLIMIT];	/* JMZ 08/03/1995 */
typedef double JSBS[2][3][12][SBLIMIT];
    JSBS /*far*/        *j_sample;
typedef double IN[14][HAN_SIZE];		/* JMZ 08/03/1995 */
    IN   /*far*/        *win_que;
typedef unsigned int SUB[14][3][12][SBLIMIT]; /* JMZ 08/03/1995 */
    SUB  /*far*/        *subband;
 
    frame_params fr_ps;
    layer info;    
    char original_file_name[MAX_NAME_SIZE];
    char encoded_file_name[MAX_NAME_SIZE];
    char encoded_file_name_ext[MAX_NAME_SIZE];
    char encoded_file_name_mpg[MAX_NAME_SIZE];
    double *win_buf[14];				/* JMZ 08/03/1995 */
    static double buffer[14][1152];			/* JMZ 08/03/1995 */			
    double spiki[14][SBLIMIT];				/* JMZ 08/03/1995 */
    static unsigned int bit_alloc[14][SBLIMIT], scfsi[14][SBLIMIT], scfsi_dyn[14][SBLIMIT];						/* JMZ 08/03/1995 */
    static unsigned int scalar[14][3][SBLIMIT], j_scale[2][3][SBLIMIT];
    static double ltmin[14][SBLIMIT], lgmin[14][SBLIMIT], max_sc[14][SBLIMIT], smr[14][SBLIMIT];							/* JMZ 08/03/1995 */
    FLOAT snr32[32];
    short sam[14][1056];					/* JMZ 08/03/1995 */
    double buffer_matr[14][1152];			/* JMZ 08/03/1995 */
    int whole_SpF, extra_slot = 0;
    double avg_slots_per_frame, frac_SpF, slot_lag;
    int model, stereo, error_protection, stereomc;
    static unsigned int crc, crcmc, crcext;
    int i, j, k, adb, p, l, m;
    unsigned long bitsPerSlot, samplesPerFrame, frameNum = 0;
    unsigned long frameBits, sentBits = 0;
    unsigned long num_samples;
    unsigned long num_samples_ml;	/* 08/03/1995 JMZ Multilingual */
    IFF_AIFF aiff_ptr;
    IFF_AIFF aiff_ptr_ml;			/* 08/03/1995 JMZ Multilingual */
    int aiff = 0;
    int byte_per_sample = 0;
    int cha_sw = 0;
    int predis = 0;
    int bit_rate = 0;
    unsigned int crc_buffer[15];
/*    char *blubb = "rm ";*/	
    char blubb[128];	/* Corrected BUG JMZ 29/03/1995*/
    
#ifdef  MACINTOSH
    console_options.nrows = MAC_WINDOW_SIZE;
    argc = ccommand(&argv);
#endif




#ifdef  PRINTOUT
    int       loop_channel,loop_subband;
    
    al_table  *loop_alloc; /* a pointer to a table */
    sb_alloc  loop_struct; /* a structure of 4 int's */
    alloc_ptr loop_str_ptr; /* a pointer to an sb_alloc structure */
    float     loop_bits;
#endif





    /* Most large variables are declared dynamically to ensure
       compatibility with smaller machines */

    /*sb_sample = (SBS *) mem_alloc(sizeof(SBS), "sb_sample");   */
    j_sample = (JSBS *) mem_alloc(sizeof(JSBS), "j_sample");   

     
    win_que = (IN *) mem_alloc(sizeof(IN), "Win_que");       
    subband = (SUB *) mem_alloc(sizeof(SUB),"subband");        

 
    /* clear buffers */
    memset((char *) buffer, 0, sizeof(buffer));
    memset((char *) bit_alloc, 0, sizeof(bit_alloc));
    memset((char *) scalar, 0, sizeof(scalar));
    memset((char *) j_scale, 0, sizeof(j_scale));
    memset((char *) scfsi, 0, sizeof(scfsi));
    memset((char *) ltmin, 0, sizeof(ltmin));
    memset((char *) lgmin, 0, sizeof(lgmin));
    memset((char *) max_sc, 0, sizeof(max_sc));
    memset((char *) snr32, 0, sizeof(snr32));
    memset((char *) sam, 0, sizeof(sam));
 
    fr_ps.header = &info;
    info.mode_ext = 0;
    fr_ps.tab_num = -1;             /* no table loaded */
    fr_ps.alloc = NULL;
    info.version = MPEG_AUDIO_ID;
    info.bitrate_index = 0;
    info.lfe = 0;	    /* no low frequency effect channel present! */
    info.multiling_ch = 0;     /* not done yet */
    info.multiling_fs = 0;     /* dto */
    info.multiling_lay = 0;    /* dto */
    info.ext_bit_stream_present = 0;
    info.n_ad_bytes = 0;
    info.audio_mix = 0;
    info.dyn_cross_LR = 0;    /* C out of Lo */
    info.ext_length = 0;
    info.ext_bit = 0;
    info.copy_ident_bit = 0;
    info.copy_ident_start = 0;


    programName = argv[0];
    if(argc==1)			    /* no command-line args */
	 obtain_parameters(&fr_ps, &model, &num_samples, &num_samples_ml,/*JMZ*/ original_file_name,
		 encoded_file_name, &aiff_ptr, &aiff_ptr_ml /*JMZ*/, &aiff, &byte_per_sample, 
		 &cha_sw, encoded_file_name_ext,
		  &bit_rate, encoded_file_name_mpg);

    else
         parse_args(argc, argv, &fr_ps, &model, &num_samples,
   	      original_file_name, encoded_file_name, &aiff, &byte_per_sample, 
		 &cha_sw, &aiff_ptr, encoded_file_name_ext,
		  &bit_rate, encoded_file_name_mpg);
    print_config(&fr_ps, &model, &num_samples,
		  original_file_name, encoded_file_name, &aiff);
  
    hdr_to_frps(&fr_ps);
    stereo = fr_ps.stereo;
    stereomc = fr_ps.stereomc;
    if( aiff != 1) fr_ps.stereomc = 0;
    error_protection = info.error_protection;
 
    if (info.lay == 1) { bitsPerSlot = 32; samplesPerFrame = 384;  }
    else               { bitsPerSlot = 8;  samplesPerFrame = 1152; }
    /* Figure average number of 'slots' per frame. */
    /* Bitrate means TOTAL for both channels, not per side. */
    if(bit_rate == 0) bit_rate = bitrate[info.lay-1][info.bitrate_index];
	fprintf(stderr, "bit_rate = %d\n", bit_rate);
	fflush(stderr);    
	 avg_slots_per_frame = ((double)samplesPerFrame /
                           s_freq[info.sampling_frequency]) *
                          ((double)bit_rate / (double)bitsPerSlot);

	 whole_SpF = (int) avg_slots_per_frame;	 /* Bytes per frame within datastream*/
    printf("slots/frame = %d\n",whole_SpF);
    frac_SpF  = avg_slots_per_frame - (double)whole_SpF;
    slot_lag  = -frac_SpF;
      printf("frac SpF=%.3f, tot bit_rate=%d kbps, s freq=%.1f kHz\n",
                frac_SpF, bit_rate,
		s_freq[info.sampling_frequency]);
 
    if (frac_SpF != 0)
       printf("Fractional number of slots, padding required\n");
    else info.padding = 0;

#ifdef PRINTOUT

    printf("\nFrame ");
    for (loop_subband=0; loop_subband<SBLIMIT; loop_subband++)
      printf("%3d",loop_subband);
    printf("\n");

#endif
 
     while (get_audio(musicin, buffer, num_samples,
	  stereo, &aiff_ptr, stereomc, &fr_ps, &aiff, &byte_per_sample,
             buffer_matr) > 0) {

/*the following allocation must happen within the while-loop. 1/5/93, SR*/
	  
      info.mc_prediction_on = 0;	       
      info.tc_sbgr_select = 1;
      info.dyn_cross_on = 0;    
      for(i = 0; i < 12; i++)
      {
         info.tc_alloc[i] = 0;
 	 info.dyn_cross[i] = 0;
 	 info.dyn_second_stereo[i] = 0;
      }
      
      for( i = 0; i < 8; i++)
      {
         info.mc_pred[i] = 0;
	 for(k = 0; k < 6; k++)
	 {
	   info.delay_comp[i][k] = 0;
	   info.predsi[i][k] = 0;
	 }  
      }   
     

        fprintf(stderr, "{%4lu}", frameNum++); fflush(stderr);
          win_buf[0] = &buffer[0][0];
	  win_buf[1] = &buffer[1][0];
	  win_buf[2] = &buffer[2][0];
	  win_buf[3] = &buffer[3][0];
	  win_buf[4] = &buffer[4][0];
	  win_buf[5] = &buffer[5][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[6] = &buffer[6][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[7] = &buffer[7][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[8] = &buffer[8][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[9] = &buffer[9][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[10] = &buffer[10][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[11] = &buffer[11][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[12] = &buffer[12][0];	/* JMZ 08/03/1995 Multilingual */
	  win_buf[13] = &buffer[13][0];	/* JMZ 08/03/1995 Multilingual */

        if (frac_SpF != 0) {
          if (slot_lag > (frac_SpF-1.0) ) {
             slot_lag -= frac_SpF;
             extra_slot = 0;
             info.padding = 0;
	     printf("No padding for this frame\n"); 
          }
          else {
             extra_slot = 1;
             info.padding = 1;
             slot_lag += (1-frac_SpF);
          }
        }
	 adb = (whole_SpF+extra_slot) * bitsPerSlot;

/**************************************************************************/
/* 08/03/1995 JMZ Multilingual */
if (info.multiling_ch != 0)
{

get_audio_ml(musicin_ml, buffer, num_samples_ml, &aiff_ptr, &fr_ps, &aiff, &byte_per_sample,buffer_matr);

	for (i=0;i<3;i++) for (j=0;j<12;j++)
	for (k = 7; k < 7+info.multiling_ch; k++) 
	{
		window_subband(&win_buf[k], &(*win_que)[k][0], k);
		filter_subband(&(*win_que)[k][0], &(sb_sample)[k][i][j][0]);
	}
}

/* 08/03/1995 JMZ Multilingual */
/**************************************************************************/


       switch (info.lay) {
 
/***************************** Layer I **********************************/

          case 1 :
             for (j=0;j<12;j++)
             for (k=0;k<stereo;k++) {
                window_subband(&win_buf[k], &(*win_que)[k][0], k);
                filter_subband(&(*win_que)[k][0], &(/***/sb_sample)[k][0][j][0]);
             }

             I_scale_factor_calc(sb_sample, scalar, stereo);
             if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {
                I_combine_LR(sb_sample, *j_sample);
				 I_scale_factor_calc(/***/sb_sample, scalar, 1);
             }
 
             put_scale(scalar, &fr_ps, max_sc);
 
             I_Psycho_One(buffer, max_sc, ltmin, &fr_ps);
 
             I_main_bit_allocation(ltmin, bit_alloc, &adb, &fr_ps);
 
             if (error_protection) I_CRC_calc(&fr_ps, bit_alloc, &crc);
 
             encode_info(&fr_ps, &bs);
 
             if (error_protection) encode_CRC(crc, &bs);
 
             I_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
             I_encode_scale(scalar, bit_alloc, &fr_ps, &bs);
             I_subband_quantization(scalar,/** */sb_sample, j_scale, *j_sample,
                                    bit_alloc, *subband, &fr_ps);
             I_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);
             for (i=0;i<adb;i++) put1bit(&bs, 0);
 
          break;
 
/***************************** Layer 2 **********************************/
 
	 case 2 :
 	  if( aiff != 1){
             for (i=0;i<3;i++) for (j=0;j<12;j++)
		 for (k = 0; k < stereo; k++) {
                   window_subband(&win_buf[k], &(*win_que)[k][0], k);
                   filter_subband(&(*win_que)[k][0], &(sb_sample)[k][i][j][0]);
                 }
				  
		l = 0;
		if( stereo == 2) m = 2;
		else m = 1;
                II_scale_factor_calc(sb_sample, scalar, fr_ps.sblimit,
                                     l, m);
/*****************JMZ 08/03/1995 Multilingual**************/

		if (info.multiling_ch>0)
		II_scale_factor_calc(sb_sample, scalar, fr_ps.sblimit, 7, 7+info.multiling_ch);

/*****************JMZ 08/03/1995 Multilingual**************/

  
  
                pick_scale(scalar, &fr_ps, max_sc, cha_sw, aiff);
                if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO) {
			 II_combine_LR(sb_sample, *j_sample, fr_ps.sblimit);
			 II_scale_factor_calc(*j_sample, j_scale,
						  fr_ps.sblimit, 1, 0);
		}
		
				 
		  /* this way we calculate more mono than we need */
                  /* but it is cheap */
 
                II_Psycho_One(buffer, max_sc, ltmin, &fr_ps,smr,spiki,aiff);
		        	
		

		 II_transmission_pattern(scalar, scfsi, &fr_ps);
		 
		 II_main_bit_allocation(smr, ltmin, scfsi, bit_alloc, &adb,
					  &fr_ps, &aiff, sb_sample, 
					 scalar, max_sc, cha_sw, buffer_matr,
					spiki, *j_sample, j_scale);
 
                 if (error_protection)
			 II_CRC_calc(&fr_ps, bit_alloc, scfsi, &crc);
			 
 
                 encode_info(&fr_ps, &bs);
 
                 if (error_protection) encode_CRC(crc, &bs);
  			 II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);

		 k = 0;
		 i = 2;
		 II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k , &i);
                 II_subband_quantization(scalar, sb_sample, j_scale,
                                      *j_sample, bit_alloc, *subband, &fr_ps);
                 II_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);
        
/*******************************************************/
/* 08/03/1995 JMZ Multilingual */
	if(info.multiling_ch >0)
	{
	
		k = 7;
		i = info.multiling_ch+7;		 
		II_encode_bit_alloc_ml(bit_alloc, &fr_ps, &bs);
		II_encode_scale_ml(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);

		II_subband_quantization_ml(scalar, sb_sample, j_scale,
			*j_sample, bit_alloc, *subband, &fr_ps);


		II_sample_encoding_ml(*subband, bit_alloc, &fr_ps, &bs);
	}
/* 08/03/1995 JMZ Multilingual */
/*******************************************************/


                 for (i=0;i<adb;i++){
		  put1bit(&bs, 0);
		  } 
		 
	  }

/*********************** Now Layer 2 with five channels**************************/

	  else{
	     for (i=0;i<3;i++) for (j=0;j<12;j++)
		for (k = 0; k < stereo+stereomc; k++) {
                   window_subband(&win_buf[k], &(*win_que)[k][0], k);
                   filter_subband(&(*win_que)[k][0], &(sb_sample)[k][i][j][0]);
                }
 
 
 
 
		matricing(sb_sample, &fr_ps);
		l = 0; m = 7;
                II_scale_factor_calc(sb_sample, scalar, fr_ps.sblimit,
                                     l, m);

/*****************JMZ 08/03/1995 Multilingual**************/

		if (info.multiling_ch>0)
		II_scale_factor_calc(sb_sample, scalar, fr_ps.sblimit, 7, 7+info.multiling_ch);
		
/*****************JMZ 08/03/1995 Multilingual**************/
				     

		 pick_scale(scalar, &fr_ps, max_sc, cha_sw, aiff);


		 if(fr_ps.actual_mode == MPG_MD_JOINT_STEREO)
                 {
                         fprintf(stderr,"JOINT!!\n");fflush(stderr);
                         i = 0;		
                	 II_combine_LR(sb_sample, *j_sample, fr_ps.sblimit);
			 II_scale_factor_calc1(*j_sample, j_scale,
						 fr_ps.sblimit, i);
		 }

                II_Psycho_One(buffer_matr, max_sc, ltmin, 
                                                &fr_ps, smr, spiki,aiff);
		
		
		 II_transmission_pattern(scalar, scfsi, &fr_ps);

 	 /*in case of ext_bit_stream adb is the complete number of bits!! 06/22/94, SR*/
 
 		 II_main_bit_allocation(smr, ltmin, scfsi, bit_alloc, &adb, 
		                         &fr_ps, &aiff, sb_sample, 
					scalar, max_sc, cha_sw, buffer_matr, 
					spiki, *j_sample, j_scale);
					
					
	    	    /* PREDISTORTION, 4/7/94, SR*/
/* 17/03/1995 JMZ TEST MULTILINGUAL */
		if(fr_ps.actual_mode != MPG_MD_JOINT_STEREO)
		{
		    if(fr_ps.actual_mode != MPG_MD_JOINT_STEREO)
		    {
			if(info.matrix == 0)
			{
	    		    adb = (whole_SpF+extra_slot) * bitsPerSlot;
			    predistortion(sb_sample,scalar, bit_alloc,
				*subband, &fr_ps, smr, scfsi, &adb);
			    predis = 1; 
			}   
		    }	    
		}	    
/* 17/03/1995 JMZ TEST MULTILINGUAL */
		/********** PREDISTORTION-END*****/



 		 if (error_protection)
			 II_CRC_calc(&fr_ps, bit_alloc, scfsi, &crc);
			 
		 II_CRC_calcmc(&fr_ps, bit_alloc, scfsi, &crcmc);


                 encode_info(&fr_ps, &bs);
		
                 if (error_protection) encode_CRC(crc, &bs);

		 II_encode_bit_alloc(bit_alloc, &fr_ps, &bs);
		 k = 0;
		 i = 2;		 

		 II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);
		 
                 II_subband_quantization(scalar, sb_sample, j_scale,
                                  *j_sample, bit_alloc, *subband, &fr_ps);
				  
				  
		 II_sample_encoding(*subband, bit_alloc, &fr_ps, &bs);


	  /***** Now bitstream for the surround channels **************/
	  

		 encode_infomc1(&fr_ps, &bs);
		 
		 encode_CRC(crcmc, &bs);
		 
		 encode_infomc2(&fr_ps, &bs);    /*new draft 5.7.93 SR*/
		 
/************************/
/****************************/
		 II_encode_bit_allocmc(bit_alloc, &fr_ps, &bs);
		 k = 2;
		 i = 5;
		 
		 II_encode_scale(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);


		 II_subband_quantizationmc(scalar, sb_sample, j_scale,
		            *j_sample, bit_alloc, *subband, &fr_ps);
				    
		 II_sample_encodingmc(*subband, bit_alloc, &fr_ps, &bs);

/***********************************************/
/* 08/03/1995 JMZ Multilingual */
	if(info.multiling_ch >0)
	{

		k = 7;
		i = info.multiling_ch+7;		 
		II_encode_bit_alloc_ml(bit_alloc, &fr_ps, &bs);
		II_encode_scale_ml(bit_alloc, scfsi, scalar, &fr_ps, &bs, &k, &i);

		II_subband_quantization_ml(scalar, sb_sample, j_scale,
			*j_sample, bit_alloc, *subband, &fr_ps);


		II_sample_encoding_ml(*subband, bit_alloc, &fr_ps, &bs);
	}

/* 08/03/1995 JMZ Multilingual */
/***********************************************/


		 for (i = 0; i < adb; i++)
                           put1bit(&bs, 0);


	  }

          
 
/***************************** Layer 3, not done yet!!*******************/

          /*case 3 : break;*/

       }
 
       frameBits = sstell(&bs) - sentBits;
       if(frameBits%bitsPerSlot)   /* a program failure */
          fprintf(stderr,"Sent %ld bits = %ld slots plus %ld\n",
                  frameBits, frameBits/bitsPerSlot,
                  frameBits%bitsPerSlot);
       sentBits += frameBits;

#ifdef PRINTOUT
       printf("\nFrame %4lu   channel 1  channel 2  channel 3  channel 4  channel 5\n",frameNum-1);
       for (loop_subband=0; loop_subband<SBLIMIT; loop_subband++)
       {
         printf("subband %2d :",loop_subband);
         for (loop_channel=0; loop_channel<fr_ps.stereo + stereomc; loop_channel++)
         {
           /* make loop_alloc point to the alloc-table in fr_ps */
           loop_alloc=fr_ps.alloc;
           loop_bits=(* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].bits;
	   if ((loop_channel==1) && 
	       (fr_ps.actual_mode == MPG_MD_JOINT_STEREO) &&
	       (loop_subband >= fr_ps.jsbound))
	       printf("js         ");
           else
	   {
	     if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].steps == 0)
	       printf("    - bits ");
	     else
	     {
	       if ((* loop_alloc)[loop_subband][bit_alloc[loop_channel][loop_subband]].group == 1)
		 loop_bits /= 3;
	       printf("%5.1f bits ",loop_bits);
	     }
	   }
         } /* for (loop_channel..) */
         printf("\n");
       } /* for (loop_subband..) */
#endif
}/* end of while(get_audio) - loop */


close_bit_stream_w(&bs);

if(info.ext_bit_stream_present == 1)
{
    open_bit_stream_r(&bs, encoded_file_name, BUFFER_SIZE);
    strcat(strcpy(encoded_file_name_ext, encoded_file_name), EXT_DFLT_EXT);
    printf(">>> file name of extension bitstream is: %s\n", encoded_file_name_ext);
    open_bit_stream_w(&bs_ext, encoded_file_name_ext, BUFFER_SIZE);
    strcat(strcpy(encoded_file_name_mpg, encoded_file_name), DFLT_EXT);
    open_bit_stream_w(&bs_mpg, encoded_file_name_mpg, BUFFER_SIZE);
    for( m = 0; m <= frameNum - 1 /* JMZ BUG 27/03/1995 */; m++)
    {	/*Changed "< frameNum -2" to "<=  frameNum -1" in case only one frame*/
	i =  (((double)samplesPerFrame / s_freq[info.sampling_frequency]) *
	     (double)bitrate[info.lay-1][info.bitrate_index]) - (info.n_ad_bytes * 8);
	for(j = 0; j < i; j++)
	{
	    crc_buffer[0] = get1bit(&bs);
	    put1bit(&bs_mpg, crc_buffer[0]);
	}
	for(j = 0; j < info.n_ad_bytes * 8; j++)
	    put1bit(&bs_mpg, 0);
      
	encode_infomc_ext1(&fr_ps, &bs_ext);
	for( i = 0; i < 14; i++)
	{
	    crc_buffer[i] = getbits(&bs, 8);
	}    
	crc_buffer[14] = getbits(&bs, 4);
	II_CRC_calcmc_ext(&fr_ps, crc_buffer, &crcext);
	encode_infomc_ext2(&fr_ps, &bs_ext, crcext);
	for( i = 0; i < 14; i++)	
	{
	    putbits(&bs_ext, crc_buffer[i], 8);
	}    
	putbits(&bs_ext, crc_buffer[14], 4);
    
	i = (info.ext_length * 8) - 40 - 116;
	for(j = 0; j < i; j++)
	{
	    crc_buffer[0] = get1bit(&bs);
	    put1bit(&bs_ext, crc_buffer[0]);
	}
    }
    close_bit_stream_r(&bs);
    close_bit_stream_w(&bs_ext);
    close_bit_stream_w(&bs_mpg);
    
    strcpy(blubb,  "rm ");				/* Corrected BUG JMZ 29/03/1995*/
    strcat(blubb,  encoded_file_name);

#ifdef DEBUG
    printf("%s\n", blubb);
#endif DEBUG

    system(blubb);
}    	

printf("Avg slots/frame = %.3f; b/smp = %.2f; br = %.3f kbps\n",
      (FLOAT) sentBits / (frameNum * bitsPerSlot),
      (FLOAT) sentBits / (frameNum * samplesPerFrame),
      (FLOAT) sentBits / (frameNum * samplesPerFrame) *
       s_freq[info.sampling_frequency]);

 if (fclose(musicin) != 0){
       printf("Could not close \"%s\".\n", original_file_name);
       exit(2);
 }

#ifdef  MACINTOSH
    set_mac_file_attr(encoded_file_name, VOL_REF_NUM, CREATOR_ENCODE,
                      FILETYPE_ENCODE);
#endif

    printf("Encoding of \"%s\" with psychoacoustic model %d is finished\n",
           original_file_name, model);
    if( aiff == 1) printf(" It is a multichannel file !\n");
    else printf(" It is a twochannel file!\n");	   
    printf("The MPEG encoded output file name is \"%s\"\n",
            encoded_file_name);
	    
}
 
/************************************************************************
/*
/* usage
/*
/* PURPOSE:  Writes command line syntax to the file specified by #stderr#
/*
/************************************************************************/

static void usage(void)  /* print syntax & exit */
{
    fprintf(stderr,
    "usage: %s                         queries for all arguments, or\n",
            programName);
    fprintf(stderr,
    "       %s [-l lay][-m mode][-p psy][-s sfrq][-b br][-d emp]\n",
            programName);
    fprintf(stderr,
    "          [-c][-o][-e] inputPCM [outBS]\n");
    fprintf(stderr,"where\n");
    fprintf(stderr," -l lay   use layer <lay> coding   (dflt %4u)\n",DFLT_LAY);
    fprintf(stderr," -m mode  channel mode : s/d/j/m   (dflt %4c)\n",DFLT_MOD);
    fprintf(stderr," -n mode  surround mode : s/d/j/m  (dflt %4c)\n",DFLT_MOD);
    fprintf(stderr," -r sfrq  input smpl rate in kHz   (dflt %4.1f)\n",DFLT_SFQ);
    fprintf(stderr," -b br    total bitrate in kbps    (dflt %4u)\n",DFLT_BRT);
    fprintf(stderr," -d emp   de-emphasis n/5/c        (dflt %4c)\n",DFLT_EMP);
    fprintf(stderr," -c       mark as copyright\n");
    fprintf(stderr," -o       mark as original\n");
    fprintf(stderr," -e       add error protection\n");
    fprintf(stderr," -g matr  matrix                    (dflt 0)\n");
    fprintf(stderr," -k       channel-switching         (dflt no)\n");
    fprintf(stderr," inputPCM input PCM sound file (standard or AIFF)\n");
    fprintf(stderr," outBS    output bit stream of encoded audio (dflt inName+%s)\n",
            DFLT_EXT);
    exit(1);
}

/************************************************************************
/*
/* aiff_check
/*
/* PURPOSE:  Checks AIFF header information to make sure it is valid.
/*           Exits if not.
/*
/************************************************************************/

void aiff_check(char *file_name, IFF_AIFF *pcm_aiff_data)
                          /* Pointer to name of AIFF file */
                          /* Pointer to AIFF data structure */
{

    if (strcmp(pcm_aiff_data->sampleType, IFF_ID_SSND) != 0)  {
       printf("Sound data is not PCM in \"%s\".\n", file_name);
       exit(0);
    }

    if(SmpFrqIndex((long)pcm_aiff_data->sampleRate) < 0) {
       printf("in \"%s\".\n", file_name);
       exit(0);
    }

    if (pcm_aiff_data->sampleSize != sizeof(short) * BITS_IN_A_BYTE) {
        printf("Sound data is not %d bits in \"%s\".\n",
               sizeof(short) * BITS_IN_A_BYTE, file_name);
        exit(0);
    }

    if (pcm_aiff_data->numChannels != MONO &&
        pcm_aiff_data->numChannels != STEREO &&
	pcm_aiff_data->numChannels != 3 &&  /*changed that to five-channel 21.6.93.SR*/
	pcm_aiff_data->numChannels != 4 &&
	pcm_aiff_data->numChannels != 5) {
       printf("Sound data is not mono or stereo or fivechannel in \"%s\".\n", file_name);
       exit(0);
    }

    if (pcm_aiff_data->blkAlgn.blockSize != 0) {
       printf("Block size is not %lu bytes in \"%s\".\n", 0, file_name);
       exit(0);
    }

    if (pcm_aiff_data->blkAlgn.offset != 0) {
       printf("Block offset is not %lu bytes in \"%s\".\n", 0, file_name);
       exit(0);
    }

}
