
/*

This software module was originally developed by

    Kazuyuki Iijima (Sony Corporation)

    in the course of development of the MPEG-4 Audio standard (ISO/IEC 14496-3).
    This software module is an implementation of a part of one or more
    MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio
    standard (ISO/IEC 14496-3).
    ISO/IEC gives users of the MPEG-4 Audio standards (ISO/IEC 14496-3)
    free license to this software module or modifications thereof for use
    in hardware or software products claiming conformance to the MPEG-4
    Audio standards (ISO/IEC 14496-3).
    Those intending to use this software module in hardware or software
    products are advised that this use may infringe existing patents.
    The original developer of this software module and his/her company,
    the subsequent editors and their companies, and ISO/IEC have no
    liability for use of this software module or modifications thereof in
    an implementation.
    Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3)
    conforming products. The original developer retains full right to use
    the code for his/her own purpose, assign or donate the code to a third
    party and to inhibit third party from using the code for non MPEG-4
    Audio (ISO/IEC 14496-3) conforming products.
    This copyright notice must be included in all copies or derivative works.

    Copyright (c)1996.

*/

#ifndef _hvxcCommon_h
#define _hvxcCommon_h

#define L               8

#ifdef __cplusplus
extern "C" {
#endif

int IPC_inint(float x);

void IPC_window(
float		*coef,
float		*aryi,
float		*aryo,
int		n);

void IPC_fft(
float		*x,
float		*y,
int		dim);

void IPC_ifft(
float		*x,
float		*y,
int		dim);

void IPC_fcall_fft(
float		*arys,
float		*rms,
float		*ang,
float		*re,
float		*im);

void IPC_lsp_lpc(
float	*lsf,
float	*alpha);

void IPC_makeCoef(
float	*coef,
int	n);

#ifdef __cplusplus
}
#endif

#endif		/* _hvxcCommon_h */
