/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Takehiro Moriya (NTT)                                                   */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Takehiro Moriya (NTT) on 1997-08-01,                                    */
/*   Naoki Iwakami (NTT) on 1997-08-25,                                      */
/*   Takehiro Moriya (NTT) on 1997-10-14,                                    */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/

/* 25-aug-97   NI   bugfixes */



#include   "ntt_conf.h"

void     ntt_extend_pitch(
	      /* Input */
	      int     index_pit[], 
	      double  reconst[], 
	      /* Output */
	      double  pit_seq[])
{
    /*--- Variables ---*/
    int	   i_smp;
    static int InitFlag = 1;
    double dtmp, pitch;
    int npcount, iscount, top, ptop;
    int i_sup, ii,jj;
    static double fcmin, fcmax;
    double bandwidth;
    fcmin = log((double)((ntt_N_FR*2/(double)ntt_ISAMPF/1000.)*100))/log(2.);
    fcmax = log((double)((ntt_N_FR*2/(double)ntt_ISAMPF/1000.)*1200))/log(2.);
    InitFlag = 0;
    bandwidth =4.0;
    if(ntt_ISAMPF==8) bandwidth=1.5;
    if(ntt_ISAMPF==11) bandwidth=2.;
    if(ntt_ISAMPF==16) bandwidth=2.;
    if(ntt_ISAMPF==22) bandwidth=4.;
    if(ntt_ISAMPF>=44) bandwidth=8.;

    for(i_sup=0; i_sup<ntt_N_SUP; i_sup++){
        top = i_sup * ntt_N_FR;
	ptop = i_sup * ntt_N_FR_P;
	dtmp = (double)index_pit[i_sup] / (double) ntt_BASF_STEP;
	dtmp = dtmp * (fcmax-fcmin) + fcmin;
	pitch = pow(2., dtmp);
	npcount = (int)(ntt_N_FR_P*bandwidth/(ntt_N_FR/pitch));
        iscount=0;
        for (jj=0; jj<ntt_N_FR; jj++){
		    pit_seq[jj+top] = 0.0;
        }
        for (jj=0; jj<npcount/2; jj++){
		    pit_seq[jj+top] = reconst[jj+ptop];
		    iscount ++;
        }
        for (ii=0; ii<(ntt_N_FR_P )&& (iscount<ntt_N_FR_P); ii++){
	    i_smp = (int)(pitch*(ii+1)+0.5);
	    if(i_smp+(npcount-1)/2+1>=ntt_N_FR) continue;
            for (jj=-npcount/2; jj<(npcount-1)/2+1; jj++){
	       pit_seq[i_smp+jj+top] = reconst[iscount+ptop];
               iscount ++;
	       if(iscount >= ntt_N_FR_P) break;
	    }
        }
    }

}
