/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Kazunori Mano (NTT)                                                     */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/



/***************************************/
/* quantization in ntt_mulaw-scale         */
/* coded by K. Mano    28/Jul/1988     */
/***************************************/
#include <math.h>


#ifdef __cplusplus
extern "C" {
#endif

double ntt_mulawinv(double y, double xmax, double mu)
{
   double x,sgn;
   if (y>xmax) y=xmax; else if (y< -xmax) y= -xmax;
   if (y<0.) sgn= -1.; else sgn=1.; 
   x = sgn*xmax*(pow(10.,fabs(y)*log10(1.+mu)/xmax)-1.)/mu;
   return(x);
}

#ifdef __cplusplus
}
#endif
