/* $Id */
/* $Log */
/*
   audio.h -- Definitions for generic real time audio I/O
   language: C
   author  : Paris Smaragdis
   copyright: (c) 1996 MIT Media Lab, All Rights Reserved
*/
/*********************************************************************

This software module was originally developed by

Paris Smaragdis (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

#include <stdio.h>

#ifdef __alpha
#include <signal.h>
#include <mme/mme_api.h>

/* Interrupt function */
void soundInterrupt( int);

/* Buffer structure */
typedef struct {
  void *lpData;
  BOOL available;
} buffer_t;

#endif

#ifdef __sgi
#include <audio.h>
typedef int BOOL;
#endif

/* Sound output functions */
int soundOutOpen( int, int, int);
int soundOutClose( int);
int soundOutQueue( short *);

/* Sound input functions */
int soundInOpen( int, int, int);
int soundInClose( int);
