/* $Id */
/* $Log */
/*********************************************************************

This software module was originally developed by

Eric D. Scheirer (MIT Media Laboratory)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard.  ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation.

This software module is hereby released into the public domain.

***********************************************************************/

/*******************************************************\
*  dpwelib.h						*
*  little header to try and setup STDC for my lib	*
*  dpwe 28may91						*
\*******************************************************/

/* WHAT'S HERE:  a bunch of stuff typically needed for my code
                 - but you might not need it all
 Includes (& what they are needed for)
   * <stdio.h>	(printf, FILE, stderr, fopen, (size_t))
   * <stdlib.h> or equivalent (malloc, atof, labs, NULL, size_t)
   * <fcntl.h>	(O_RDONLY etc)   		 
   * <string.h>	(strcmp, rindex, strrchr)
 Defines
   * READMODE, WRITEMODE for fopen of binary files
   * FLOATARG for type of floats in prototypes
 Macros
   * TMMALLOC(type, count, errmsg) allocates a pointer to <count> of <type>
   * MIN, MAX (arguments evaluated twice)
   * PARG -- for optional argument prototypes : void fn PARG((type arg));
 PARG is pretty important, but you could include it explicitly 
 in any stand-alone header you wanted to build.
   * DBGFPRINTF(()) - like fprintf *except* must use double brackets, 
     only does anything if -DDEBUG
 */

#ifndef _DPWELIB_H_
#define _DPWELIB_H_

#include <stdio.h>
#include <assert.h>	/* recently a favourite */
/* Prototype argument wrapper */
/* make fn protos like   void fn PARG((int arg1, char arg2));  */
#ifdef __STDC__
#define PARG(a)		a
#else /* !__STDC__ */
#define PARG(a)		()
#endif /* __STDC__ */

/* 2nd try - setup PARG for C++ too */
#ifdef __cplusplus
#undef PARG
#define PARG(a)		a
#endif /* __STDC__ */

#ifdef THINK_C
/* #define __STDC__ 1 */ /* THINKC 5 has stdc mode */
#include <stdlib.h>		/* for malloc prototype */
#include <fcntl.h>
#include <string.h>
/* #include <pascal.h> */		/* for PtoCstr prototype */
#define	hypot(a,b)	sqrt(pow(a,2.0)+pow(b,2.0))
#ifndef READMODE
#define READMODE "rb"
#define WRITEMODE "wb+"
#endif /* READMODE */

#else  /* Unix, not mac (THINK_C) */

#include <sys/types.h>

#ifdef sun
#ifdef SUNOS41
#include <sys/stdtypes.h>	/* for size_t on suns */
#else /* Solaris */
#include <sys/types.h>	/* for size_t on suns */
#endif /* SUNOS41/Solaris */
#endif /* sun */

#ifndef READMODE
#define READMODE "rb"
#define WRITEMODE "wb+"
#endif /* READMODE */

#ifdef sun
#ifndef SUNOS41
#define SOLARIS
#endif /* !SUNOS41 */
#endif /* sun */

#ifdef NeXT
#include <stdlib.h>
#else  /* not NeXT */
#ifdef __sgi 
#include <stdlib.h>
#else  /* ultrix, not sgi or NeXT */
#ifdef __alpha
#include <stdlib.h>
#else /* not even alpha */
#ifdef SOLARIS
#include <stdlib.h>
#else /* nor solaris */
#ifdef _WIN32
#else
#include <unistd.h>
#include <malloc.h>
#endif
#endif /* SOLARIS */
#endif /* __alpha */
#endif /* __sgi */
#endif /* NeXT */

#ifndef SYS5
#ifndef sun
#ifndef _WIN32
#include <strings.h>
#define STRINGS_INC
#endif
#endif  /* not sun */
#endif	/* not SYS5 */

#ifndef STRINGS_INC /* sun or SYS5 */
#include <fcntl.h>
#include <string.h>
#ifdef SUNOS41
#define  strchr(A,B) 	index(A,B)
#define  strrchr(A,B)	rindex(A,B)
#endif /* SUNSO41 */
#endif  /* sun or SYS5 */

#endif /* mac or Unix */

/* some general utilities to put in a .h file */
#ifndef MIN
#define MIN(a,b)	(((a)>(b))?(b):(a))
#define MAX(a,b)	(((a)>(b))?(a):(b))
#endif /* !MIN */

/* from genutils.h .. need them earlier! */
char *Mymalloc PARG((long num, long siz, char *title));
void Myfree PARG((char *ptr, char *title));

#define TMMALLOC(type,num,msg)	(type *)malloc(num * sizeof(type))
#define TMFREE(ptr,msg)		free((char *)ptr)

#ifdef DEBUG
#define DBGFPRINTF(a)	fprintf a
#define FPRINTF(a)	fprintf a
#ifdef THINK_C
#define ERRTOFILE
#define ABORT		Debugger()
#else  /* DEBUG, !THINK_C */
#define ABORT		abort()
#endif /* THINK_C */
#ifdef ERRTOFILE
#undef stderr
#define stderr	((errfile==NULL)?(errfile=fopen("stderr.log","w")):errfile)
extern FILE *errfile;
#endif /* ERRTOFILE */
#else /* !DEBUG */
#define DBGFPRINTF(a)	/* no DBGFPRINTFs if not debug */
#ifdef THINK_C
#define FPRINTF(a)	/* also, no fprintfs at all on mac */
#define ABORT		return 0	/* .. lame excuse for abort */
#else /* !THINK_C */
#define FPRINTF(a)	fprintf a
#define ABORT		abort()
#endif /* THINK_C */
#endif /* DEBUG */


/* hmm.. generally useful types? */
#define FLOATARG	double	/* for arguments - promotes anyway */

#ifdef __GNUC__
#ifdef __alpha
#define _UCHAR_DEFINED_   /* in /lib/gcc-lib/alpha-dec-osf2.0/2.5.8/include/sys/types.h:352 it says here */
#endif /* __alpha */
#endif /* __GNUC__ */

#ifndef _UCHAR_DEFINED_
typedef unsigned char uchar;
#define _UCHAR_DEFINED_
#endif /* _UCHAR_DEFINED_ */

#ifndef BYTE
#ifndef BYTE_DEFINED
#define BYTE	uchar
#define BYTE_DEFINED
#endif /* BYTE_DEFINED */
#endif /* BYTE */

#ifndef INT32
#ifndef INT32_DEFINED
#ifdef THINK_C	/* ints can be only 16 bit on THINK, so use long */
#define INT32	long
#else	/* !THINK_C - use int; longs are 64 bit on alpha */
#define INT32	int
#endif /* THINK_C */
#define INT32_DEFINED
#endif /* INT32_DEFINED */
#endif /* INT32 */

#ifndef PI
#ifdef M_PI
#define PI M_PI
#else  /* M_PI */
#define PI	3.14159265358979323846
#endif /* M_PI */
#endif /* PI */

#ifndef TWOPI
#define TWOPI 	(2.0*PI)
#endif /* TWOPI */

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#endif /* _DPWELIB_H_ */
