/*

This software module was originally developed by 

Mike Guzewicz (E-mu Systems)


in the course of development of the MPEG-4 Audio (ISO/IEC 14496-3) standard. 
This software module is an implementation of a part of one or more 
MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio 
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC 14496-3) 
free license to this software module or modifications thereof for use 
in hardware or software products claiming conformance to the MPEG-4 Audio 
(ISO/IEC 14496-3). Those intending to use this software module in hardware 
or software products are advised that its use may infringe existing patents. 
The original developer of this software module and his/her company, the 
subsequent editors and their companies, and ISO/IEC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming 
products. E-mu Systems retains full right to use the code for his/her own 
purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for non MPEG-4 Audio (ISO/IEC 14496-3) 
conforming products. This copyright notice must be included in all copies 
or derivative works. 

Copyright (C) 1997 E-mu Systems, Inc.

*/
     /*********************************************************************
     
     sfe_sfdata.h
     
     
     
     *********************************************************************/
#ifndef __SFDATA_H
#define __SFDATA_H



/*****************************************************************************
*  @(#)sfdata.h	1.1 12:06:31 3/15/95 12:06:36
*
* Filename: sfdata.h
*
* Description: SoundFont Data Structure
*
*******************************************************************************
*/

/*
/////////////////////////////
//       Includes          //
/////////////////////////////
*/

#include "sfe_datatype.h" 

#define PRESETNAMESIZE 20
#define SAMPLENAMESIZE 20

typedef struct sfPresetHdrTag
{
  CHAR   achPresetName[PRESETNAMESIZE];      
  WORD   wPresetNum;                   
  WORD   wPresetBank;               
  WORD   wBagNdx;                  
  DWORD  dwLibrary;
  DWORD  dwGenre;
  DWORD  dwMorphology;

} sfPresetHdr;

/*
// A flag in the sfSampleType field of the Sample Header data structure.
// This flag indicates that the sampled waveform it uses
// is expected to be on a WaveTable ROM, and is NOT in the file.
*/
#define romSample 0x8000

/*
// The other defined values for the sfSampleType field of the Sample Header
// data structure.
*/
typedef enum {   

  monoSample   = 1, /* The sample is a MONO sample */
  rightSample  = 2, /* The sample is the RIGHT sample of a stereo pair */
                    /* or the first in a group of linked samples */
  leftSample   = 4, /* The sample is the LEFT sample of a stereo pair */
  linkedSample = 8  /* The sample is another in a group of linked samples */
                    /* the last of which should point to the sample with */
                    /* rightSample set. */
 
}SFSampleLink; 

#ifdef _cplusplus
const WORD smplHdrV2ExtensionSize    =  (3*sizeof(WORD)+sizeof(DWORD));
const WORD smplHdrV2Size             =  36 + (3*sizeof(WORD)+sizeof(DWORD));
#endif
 
/* Standard list used in Shdr (Sample header lists) */
typedef struct sfSampleHdrTag
{
 
  CHAR          achSampleName[SAMPLENAMESIZE];
  DWORD         dwStart;       
  DWORD         dwEnd;
  DWORD         dwStartloop;
  DWORD         dwEndloop;
  DWORD         dwSampleRate;   
  BYTE          byOriginalKey;  
  CHAR          chFineCorrection;
  WORD          wSampleLink; 
  WORD          sfSampleType; 

  BOOL          bSampleLoaded; 
                 
                  

  WORD  wRefCount; 

} sfSampleHdr;

#if defined (EMU_WINDOWS) || defined (DOS_MEMORY)
typedef sfPresetHdr huge* SFPRESETHDRPTR;
typedef sfSampleHdr huge* SFSAMPLEHDRPTR;
#else
typedef sfPresetHdr* SFPRESETHDRPTR;
typedef sfSampleHdr* SFSAMPLEHDRPTR;
#endif

typedef enum sfSampleFlagsTag
{
  NOFLAG = 0,
  ZL = 1,
  ZR = 2,
  LINKED = 4,
  FIRST_LINK = 8
} sfSampleFlags;

/*
//////////////////////////////////////////////
// SoundFont Navigator Vector Data Structure//
//////////////////////////////////////////////
*/

typedef struct sfDataTag
{
  DWORD dwStart;             
  DWORD dwEnd;
  DWORD dwStartloop;        
  DWORD dwEndloop;         
  DWORD dwSampleRate; 
  SHORT shOrigKeyAndCorr;
  SHORT shSampleModes;
  SHORT shSampleLink;

  SHORT  shCoarseTune;
  SHORT  shFineTune;
  SHORT  shScaleTuning;
  SHORT  shModLfoToPitch;            
  SHORT  shVibLfoToPitch;           
  SHORT  shModEnvToPitch;          

  SHORT   shInitialFilterFc;        
  SHORT   shInitialFilterQ;         
  SHORT   shModLfoToFilterFc;         
  SHORT   shModEnvToFilterFc;         

  SHORT   shInstVol;                
  SHORT   shModLfoToVolume;           

  SHORT   shChorusEffectsSend;      
  SHORT   shReverbEffectsSend;      
  SHORT   shPanEffectsSend;         

  
  SHORT   shDelayModLfo;              
  SHORT   shFreqModLfo;               

  
  SHORT   shDelayVibLfo;              
  SHORT   shFreqVibLfo;               

  
  SHORT   shDelayModEnv;              
  SHORT   shAttackModEnv;             
  SHORT   shHoldModEnv;               
  SHORT   shDecayModEnv;              
  SHORT   shSustainModEnv;            
  SHORT   shReleaseModEnv;            
  SHORT   shAutoHoldModEnv;
  SHORT   shAutoDecayModEnv;

  
  SHORT   shDelayVolEnv;              
  SHORT   shAttackVolEnv;             
  SHORT   shHoldVolEnv;               
  SHORT   shDecayVolEnv;              
  SHORT   shSustainVolEnv;            
  SHORT   shReleaseVolEnv;            
  SHORT   shAutoHoldVolEnv;
  SHORT   shAutoDecayVolEnv;

  
  SHORT   shKeyExclusiveClass;

  
  SHORT   shKeynum;                 
  SHORT   shVelocity;               

  
  SHORT   shStartAddrsCoarseOffset;
  SHORT   shEndAddrsCoarseOffset;
  SHORT   shStartloopAddrsCoarseOffset;
  SHORT   shEndloopAddrsCoarseOffset;
  SHORT   shOverridingRootKey;

  
  SHORT   shNOP;
  SHORT   shEndOper;
} sfData;




#endif 
