/* dither.c */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Id: dither.c,v 1.5 1995/06/12 15:38:36 brianp Exp $

$Log: dither.c,v $
 * Revision 1.5  1995/06/12  15:38:36  brianp
 * changed color arrays to GLubyte
 *
 * Revision 1.4  1995/05/22  21:02:41  brianp
 * Release 1.2
 *
 * Revision 1.3  1995/03/04  19:29:44  brianp
 * 1.1 beta revision
 *
 * Revision 1.2  1995/02/27  22:48:43  brianp
 * modified for PB
 *
 * Revision 1.1  1995/02/24  14:20:36  brianp
 * Initial revision
 *
 */


#include <stdlib.h>
#include "context.h"




void gl_dither_color_span( GLuint n, GLint x, GLint y,
			   GLubyte red[], GLubyte green[],
			   GLubyte blue[], GLubyte alpha[],
			   const GLubyte mask[] )
{
   register GLuint i;

   for (i=0;i<n;i++,x++) {
      if (mask[i]) {
	 register GLint d = (x ^ y) & 1;
	 if (red[i]>0)    red[i] -= d;
	 if (green[i]>0)  green[i] -= d;
	 if (blue[i]>0)   blue[i] -= d;
	 if (alpha[i]>0)  alpha[i] -= d;
      }
   }
}




void gl_dither_index_span( GLuint n, GLint x, GLint y,
			   GLuint index[], const GLubyte mask[] )
{
   register GLuint i;

   for (i=0;i<n;i++,x++) {
      if (mask[i]) {
	 if (index[i]>0)  index[i] -= ((x ^ y) & 1);
      }
   }
}



void gl_dither_color_pixels( GLuint n, const GLint x[], const GLint y[],
                             GLubyte red[], GLubyte green[],
                             GLubyte blue[], GLubyte alpha[],
                             const GLubyte mask[] )
{
   register GLuint i;

   for (i=0;i<n;i++,x++) {
      if (mask[i]) {
         register GLint d = (x[i] ^ y[i]) & 1;
         if (red[i]>0)    red[i] -= d;
         if (green[i]>0)  green[i] -= d;
         if (blue[i]>0)   blue[i] -= d;
         if (alpha[i]>0)  alpha[i] -= d;
      }
   }
}



void gl_dither_index_pixels( GLuint n, const GLint x[], const GLint y[],
                             GLuint index[], const GLubyte mask[] )
{
   register GLuint i;

   for (i=0;i<n;i++,x++) {
      if (mask[i]) {
         if (index[i]>0)  index[i] -= ((x[i] ^ y[i]) & 1);
      }
   }
}

