/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  node_partition.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef NODE_PARTITION_H
#define NODE_PARTITION_H

#include <LEDA/graph.h>



//------------------------------------------------------------------------------
// node partitions 
//------------------------------------------------------------------------------

#include <LEDA/partition.h>

class node_partition {

graph_array(node) I;
partition P;

public:
void init(const graph& G);

 node_partition(const graph& G) { P.clear(); init(G); }
~node_partition()               { P.clear();  }   

int  same_block(node v, node w)   
{ return P.same_block(partition_item(I.inf(v)),partition_item(I.inf(w))); }

void union_blocks(node v, node w) 
{ P.union_blocks(partition_item(I.inf(v)),partition_item(I.inf(w))); }

void set_inf(node v, node w) { P.set_inf(partition_item(I.inf(v)),GenPtr(w)); }

node find(node v) { return node(P.inf(P.find(partition_item(I.inf(v))))); }

node operator()(node v) { return find(v); }


};


#endif
