/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _skiplist.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




//------------------------------------------------------------------------------
//  skip lists by William Pugh
//------------------------------------------------------------------------------

#include <LEDA/skiplist.h>

/*
#define NEW_NODE(p,l)\
p = (skiplist_item)malloc(sizeof(skiplist_node)+(l)*sizeof(skiplist_node*))
#define FREE_NODE(p) free(p)
*/

#define NEW_NODE(p,l) p = skiplist_item(allocate_words(4+l)); p->level = l;
#define FREE_NODE(p)  deallocate_words(p,4+p->level)



const int BitsInRandom      = 31;
const int MaxNumberOfLevels = 16;
const int MaxLevel          = MaxNumberOfLevels-1;

static skiplist_item update[32];

skiplist::skiplist() 
{ NEW_NODE(STOP,0);
  STOP->forward[0] = 0;
  randomBits = random(0,MAXINT);
  randomsLeft = BitsInRandom/2;
  level = 0;
  NEW_NODE(header,MaxNumberOfLevels);
  for(int i=0;i<MaxNumberOfLevels;i++) header->forward[i] = STOP;
  count = 0;
 } 

skiplist::skiplist(const skiplist& L) 
{ NEW_NODE(STOP,0);
  STOP->forward[0] = 0;
  randomBits = random(0,MAXINT);
  randomsLeft = BitsInRandom/2;
  level = 0;
  NEW_NODE(header,MaxNumberOfLevels);
  for(int i=0;i<MaxNumberOfLevels;i++) header->forward[i] = STOP;
  count = 0;

  skiplist_item p = L.header->forward[0];
  while (p!= L.STOP) 
  { insert(p->key,p->inf);
    copy_key(p->key);
    copy_inf(p->inf);
    p = p->forward[0];
   }
 } 


skiplist& skiplist::operator=(const skiplist& L) 
{ clear();
  skiplist_item p = L.header->forward[0];
  while (p!= L.STOP) 
  { insert(p->key,p->inf);
    copy_key(p->key);
    copy_inf(p->inf);
    p = p->forward[0];
   }
  return *this;
 } 

void skiplist::clear() 
{ register skiplist_item p,q;
  p = header->forward[0];
  while(p!=STOP)
  { q = p->forward[0];
    clear_key(p->key);
    clear_inf(p->inf);
    FREE_NODE(p);
    p = q; 
   }
 level = 0;
 for(int i=0;i<MaxNumberOfLevels;i++) header->forward[i] = STOP;
 count = 0;
}



skiplist::~skiplist() 
{ clear();
  FREE_NODE(header);
  FREE_NODE(STOP);
 }


int skiplist::randomLevel()
{  register int level = 0;
   register int b = 0;
   while (!b)
   { b = randomBits&3;    // read next 2 random bits
     randomBits >>= 2;
     if (!b) level++;     // increase level with prob  1/4
     if (--randomsLeft == 0) 
     { randomBits = random(0,MAXINT);
       randomsLeft = BitsInRandom/2;
      }
    }
   return (level>MaxLevel) ? MaxLevel : level;
 }

#define SEARCH\
{ STOP->key = key;\
  p = header;\
  for(k=level;k>=0;k--)\
  { while (q = p->forward[k], cmp(q->key,key) < 0) p = q;\
    update[k] = p;\
   }\
  if (q == STOP || cmp(q->key,key) != 0) q=0;  }


#define INT_SEARCH\
{ STOP->key = key;\
  p = header;\
  for(k=level;k>=0;k--)\
  { while (q = p->forward[k], q->key < key) p = q;\
    update[k] = p;\
   }\
  if (q == STOP || q->key != key) q=0;  }


skiplist_item skiplist::lookup(GenPtr key) const
{ register skiplist_item p,q;
  register int k;
  if (int_type())  INT_SEARCH else  SEARCH
  return q;
 }


skiplist_item skiplist::insert(GenPtr key, GenPtr inf)
{ register int k;
  register skiplist_item p,q;

  if (int_type())  INT_SEARCH else SEARCH

  if (q) 
  { q->inf = inf;
    return q;
   }

  copy_key(key);
  copy_inf(inf);


   count++;

   k = randomLevel();
   if (k>level) 
   { k = ++level;
     update[k] = header;
    }

   NEW_NODE(q,k);
   q->key = key;
   q->inf = inf;
   while(k >= 0)
   { p = update[k];
     q->forward[k] = p->forward[k];
     p->forward[k] = q;
     k--;
    }

   return q;
 }

void skiplist::del(GenPtr key)
{ register int k,m;
  register skiplist_item p,q;

  if (int_type())  INT_SEARCH else SEARCH;

  m = level;

  if (q)
  { count --;
    for(k=0; k<=m && (p=update[k])->forward[k] == q; k++) 
      p->forward[k] = q->forward[k];
    clear_key(q->key);
    clear_inf(q->inf);
    FREE_NODE(q);
    while( header->forward[m] == STOP && m > 0 ) m--;
    level = m;
   }
 }

